/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Bind;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BindTest {
    @Test
    public void parseUsingDefaultAccessMode() {
        Bind bind = Bind.parse((String)"/host:/container");
        Assert.assertEquals((String)bind.getPath(), (String)"/host");
        Assert.assertEquals((String)bind.getVolume().getPath(), (String)"/container");
        Assert.assertEquals((boolean)bind.isReadOnly(), (boolean)false);
    }

    @Test
    public void parseReadWrite() {
        Bind bind = Bind.parse((String)"/host:/container:rw");
        Assert.assertEquals((String)bind.getPath(), (String)"/host");
        Assert.assertEquals((String)bind.getVolume().getPath(), (String)"/container");
        Assert.assertEquals((boolean)bind.isReadOnly(), (boolean)false);
    }

    @Test
    public void parseReadOnly() {
        Bind bind = Bind.parse((String)"/host:/container:ro");
        Assert.assertEquals((String)bind.getPath(), (String)"/host");
        Assert.assertEquals((String)bind.getVolume().getPath(), (String)"/container");
        Assert.assertEquals((boolean)bind.isReadOnly(), (boolean)true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind.*")
    public void parseInvalidAccessMode() {
        Bind.parse((String)"/host:/container:xx");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'nonsense'")
    public void parseInvalidInput() {
        Bind.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Bind 'null'")
    public void parseNull() {
        Bind.parse(null);
    }
}

