/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.TestDockerCmdExecFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITestResult;

public abstract class AbstractDockerClientTest
extends Assert {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractDockerClientTest.class);
    protected DockerClient dockerClient;
    protected TestDockerCmdExecFactory dockerCmdExecFactory = new TestDockerCmdExecFactory(DockerClientBuilder.getDefaultDockerCmdExecFactory());

    public void beforeTest() {
        LOG.info("======================= BEFORETEST =======================");
        LOG.info("Connecting to Docker server");
        this.dockerClient = DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)this.dockerCmdExecFactory).build();
        LOG.info("Pulling image 'busybox'");
        this.asString((InputStream)this.dockerClient.pullImageCmd("busybox").withTag("latest").exec());
        AbstractDockerClientTest.assertNotNull((Object)this.dockerClient);
        LOG.info("======================= END OF BEFORETEST =======================\n\n");
    }

    public void afterTest() {
        LOG.info("======================= END OF AFTERTEST =======================");
    }

    public void beforeMethod(Method method) {
        LOG.info(String.format("################################## STARTING %s ##################################", method.getName()));
    }

    public void afterMethod(ITestResult result) {
        for (String container : this.dockerCmdExecFactory.getContainerNames()) {
            LOG.info("Cleaning up temporary container {}", (Object)container);
            try {
                this.dockerClient.removeContainerCmd(container).withForce().exec();
            }
            catch (DockerException ignore) {
                ignore.printStackTrace();
            }
        }
        for (String image : this.dockerCmdExecFactory.getImageNames()) {
            LOG.info("Cleaning up temporary image with {}", (Object)image);
            try {
                this.dockerClient.removeImageCmd(image).withForce().exec();
            }
            catch (DockerException ignore) {
                ignore.printStackTrace();
            }
        }
        LOG.info("################################## END OF {} ##################################\n", (Object)result.getName());
    }

    protected String asString(InputStream response) {
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response, (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + (itr.hasNext() ? "\n" : ""));
            }
            String string = logwriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < 1100 || port > 60000) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

