/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateImageResponse;
import com.github.dockerjava.api.command.DockerCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.core.DockerClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class TestDockerCmdExecFactory
implements DockerCmdExecFactory {
    private List<String> containerNames = new ArrayList<String>();
    private List<String> imageNames = new ArrayList<String>();
    private DockerCmdExecFactory delegate;

    public TestDockerCmdExecFactory(DockerCmdExecFactory delegate) {
        this.delegate = delegate;
    }

    public void init(DockerClientConfig dockerClientConfig) {
        this.delegate.init(dockerClientConfig);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmd.Exec(){

            public CreateContainerResponse exec(CreateContainerCmd command) {
                CreateContainerResponse createContainerResponse = (CreateContainerResponse)TestDockerCmdExecFactory.this.delegate.createCreateContainerCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.containerNames.add(createContainerResponse.getId());
                return createContainerResponse;
            }
        };
    }

    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmd.Exec(){

            public Void exec(RemoveContainerCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveContainerCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.containerNames.remove(command.getContainerId());
                return null;
            }
        };
    }

    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmd.Exec(){

            public CreateImageResponse exec(CreateImageCmd command) {
                CreateImageResponse createImageResponse = (CreateImageResponse)TestDockerCmdExecFactory.this.delegate.createCreateImageCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.imageNames.add(createImageResponse.getId());
                return createImageResponse;
            }
        };
    }

    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmd.Exec(){

            public Void exec(RemoveImageCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveImageCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.imageNames.remove(command.getImageId());
                return null;
            }
        };
    }

    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmd.Exec(){

            public InputStream exec(BuildImageCmd command) {
                String tag = command.getTag();
                if (tag == null || "".equals(tag.trim())) {
                    tag = "" + new SecureRandom().nextInt(Integer.MAX_VALUE);
                    command.withTag(tag);
                }
                InputStream inputStream = (InputStream)TestDockerCmdExecFactory.this.delegate.createBuildImageCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.imageNames.add(tag);
                return inputStream;
            }
        };
    }

    public AuthCmd.Exec createAuthCmdExec() {
        return this.delegate.createAuthCmdExec();
    }

    public InfoCmd.Exec createInfoCmdExec() {
        return this.delegate.createInfoCmdExec();
    }

    public PingCmd.Exec createPingCmdExec() {
        return this.delegate.createPingCmdExec();
    }

    public VersionCmd.Exec createVersionCmdExec() {
        return this.delegate.createVersionCmdExec();
    }

    public PullImageCmd.Exec createPullImageCmdExec() {
        return this.delegate.createPullImageCmdExec();
    }

    public PushImageCmd.Exec createPushImageCmdExec() {
        return this.delegate.createPushImageCmdExec();
    }

    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return this.delegate.createSearchImagesCmdExec();
    }

    public ListImagesCmd.Exec createListImagesCmdExec() {
        return this.delegate.createListImagesCmdExec();
    }

    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return this.delegate.createInspectImageCmdExec();
    }

    public ListContainersCmd.Exec createListContainersCmdExec() {
        return this.delegate.createListContainersCmdExec();
    }

    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return this.delegate.createStartContainerCmdExec();
    }

    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return this.delegate.createInspectContainerCmdExec();
    }

    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return this.delegate.createWaitContainerCmdExec();
    }

    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return this.delegate.createAttachContainerCmdExec();
    }

    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return this.delegate.createLogContainerCmdExec();
    }

    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return this.delegate.createCopyFileFromContainerCmdExec();
    }

    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return this.delegate.createStopContainerCmdExec();
    }

    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return this.delegate.createContainerDiffCmdExec();
    }

    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return this.delegate.createKillContainerCmdExec();
    }

    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return this.delegate.createRestartContainerCmdExec();
    }

    public CommitCmd.Exec createCommitCmdExec() {
        return this.delegate.createCommitCmdExec();
    }

    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return this.delegate.createTopContainerCmdExec();
    }

    public TagImageCmd.Exec createTagImageCmdExec() {
        return this.delegate.createTagImageCmdExec();
    }

    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return this.delegate.createPauseContainerCmdExec();
    }

    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return this.delegate.createUnpauseContainerCmdExec();
    }

    public EventsCmd.Exec createEventsCmdExec() {
        return this.delegate.createEventsCmdExec();
    }

    public List<String> getContainerNames() {
        return new ArrayList<String>(this.containerNames);
    }

    public List<String> getImageNames() {
        return new ArrayList<String>(this.imageNames);
    }
}

