/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BuildImageCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testNginxDockerfileBuilder() {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("nginx").getFile());
        InputStream response = (InputStream)this.dockerClient.buildImageCmd(baseDir).withNoCache().exec();
        String fullLog = this.asString(response);
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse.getAuthor(), (Matcher)Matchers.equalTo((Object)"Guillaume J. Charmes \"guillaume@dotcloud.com\""));
    }

    @Test
    public void testDockerBuilderAddUrl() {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddUrl").getFile());
        this.dockerfileBuild(baseDir, "Docker");
    }

    @Test
    public void testDockerBuilderAddFileInSubfolder() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddFileInSubfolder").getFile());
        this.dockerfileBuild(baseDir, "Successfully executed testrun.sh");
    }

    @Test
    public void testDockerBuilderAddFolder() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testAddFolder").getFile());
        this.dockerfileBuild(baseDir, "Successfully executed testAddFolder.sh");
    }

    private String dockerfileBuild(File baseDir, String expectedText) {
        InputStream response = (InputStream)this.dockerClient.buildImageCmd(baseDir).withNoCache().exec();
        String fullLog = this.asString(response);
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        CreateContainerResponse container = this.dockerClient.createContainerCmd(imageId).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.waitContainerCmd(container.getId()).exec();
        InputStream logResponse = this.logContainer(container.getId());
        MatcherAssert.assertThat((Object)this.asString(logResponse), (Matcher)Matchers.containsString((String)expectedText));
        return container.getId();
    }

    private InputStream logContainer(String containerId) {
        return this.dockerClient.logContainerCmd(containerId).withStdErr().withStdOut().exec();
    }

    @Test
    public void testNetCatDockerfileBuilder() throws InterruptedException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("netcat").getFile());
        InputStream response = (InputStream)this.dockerClient.buildImageCmd(baseDir).withNoCache().exec();
        String fullLog = this.asString(response);
        MatcherAssert.assertThat((Object)fullLog, (Matcher)Matchers.containsString((String)"Successfully built"));
        String imageId = StringUtils.substringBetween((String)fullLog, (String)"Successfully built ", (String)"\\n\"}").trim();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)inspectImageResponse.getId(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        CreateContainerResponse container = this.dockerClient.createContainerCmd(inspectImageResponse.getId()).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getId(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getNetworkSettings().getPorts(), (Matcher)Matchers.notNullValue());
        this.dockerClient.stopContainerCmd(container.getId()).withTimeout(0).exec();
    }

    @Test
    public void testAddAndCopySubstitution() throws DockerException, IOException {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("testENVSubstitution").getFile());
        this.dockerfileBuild(baseDir, "testENVSubstitution successfully completed");
    }
}

