/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import ch.lambdaj.Lambda;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.ChangeLog;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ContainerDiffCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testContainerDiff() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerClient.waitContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        List filesystemDiff = this.dockerClient.containerDiffCmd(container.getId()).exec();
        LOG.info("Container DIFF: {}", (Object)filesystemDiff.toString());
        MatcherAssert.assertThat((Object)filesystemDiff.size(), (Matcher)Matchers.equalTo((Object)1));
        ChangeLog testChangeLog = (ChangeLog)Lambda.selectUnique((Object)filesystemDiff, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"kind", (Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testContainerDiffWithNonExistingContainer() throws DockerException {
        try {
            this.dockerClient.containerDiffCmd("non-existing").exec();
            ContainerDiffCmdImplTest.fail((String)"expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

