/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CopyFileFromContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void copyFromContainer() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-copyFromContainer").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InputStream response = this.dockerClient.copyFileFromContainerCmd(container.getId(), "/test").exec();
        CopyFileFromContainerCmdImplTest.assertTrue((response.available() > 0 ? 1 : 0) != 0, (String)"The file was not copied from the container.");
    }

    @Test
    public void copyFromNonExistingContainer() throws Exception {
        try {
            this.dockerClient.copyFileFromContainerCmd("non-existing", "/test").exec();
            CopyFileFromContainerCmdImplTest.fail((String)"expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

