/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.ConflictException;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CreateContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void createContainerWithExistingName() throws DockerException {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"env"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        try {
            this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"env"}).withName(containerName).exec();
            CreateContainerCmdImplTest.fail((String)"expected ConflictException");
        }
        catch (ConflictException conflictException) {
            // empty catch block
        }
    }

    @Test
    public void createContainerWithVolume() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withVolumes(new Volume[]{new Volume("/var/log")}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Inspect container {}", (Object)inspectContainerResponse.getConfig().getVolumes());
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/var/log"}));
    }

    @Test
    public void createContainerWithEnv() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withEnv(new String[]{"VARIABLE=success"}).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"VARIABLE=success", "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"}));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.asString(this.dockerClient.logContainerCmd(container.getId()).withStdOut().exec()), (Matcher)Matchers.containsString((String)"VARIABLE=success"));
    }

    @Test
    public void createContainerWithHostname() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withHostName("docker-java").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getHostName(), (Matcher)Matchers.equalTo((Object)"docker-java"));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.asString(this.dockerClient.logContainerCmd(container.getId()).withStdOut().exec()), (Matcher)Matchers.containsString((String)"HOSTNAME=docker-java"));
    }

    @Test
    public void createContainerWithName() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("container").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getName(), (Matcher)Matchers.equalTo((Object)"/container"));
        try {
            this.dockerClient.createContainerCmd("busybox").withName("container").withCmd(new String[]{"env"}).exec();
            CreateContainerCmdImplTest.fail((String)"Expected ConflictException");
        }
        catch (ConflictException conflictException) {
            // empty catch block
        }
    }
}

