/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.EventCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class EventsCmdImplTest
extends AbstractDockerClientTest {
    private static int KNOWN_NUM_EVENTS = 4;

    private static String getEpochTime() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testEventStreamTimeBound() throws InterruptedException, IOException {
        TimeUnit.SECONDS.sleep(1L);
        String startTime = EventsCmdImplTest.getEpochTime();
        int expectedEvents = this.generateEvents();
        String endTime = EventsCmdImplTest.getEpochTime();
        CountDownLatch countDownLatch = new CountDownLatch(expectedEvents);
        EventCallbackTest eventCallback = new EventCallbackTest(countDownLatch);
        EventsCmd eventsCmd = this.dockerClient.eventsCmd((EventCallback)eventCallback).withSince(startTime).withUntil(endTime);
        ExecutorService executorService = (ExecutorService)eventsCmd.exec();
        boolean zeroCount = countDownLatch.await(5L, TimeUnit.SECONDS);
        executorService.shutdown();
        EventsCmdImplTest.assertTrue((boolean)zeroCount, (String)"Expected 4 events, [create, start, die, stop]");
    }

    @Test
    public void testEventStreaming() throws InterruptedException, IOException {
        TimeUnit.SECONDS.sleep(1L);
        CountDownLatch countDownLatch = new CountDownLatch(KNOWN_NUM_EVENTS);
        EventCallbackTest eventCallback = new EventCallbackTest(countDownLatch);
        EventsCmd eventsCmd = this.dockerClient.eventsCmd((EventCallback)eventCallback).withSince(EventsCmdImplTest.getEpochTime());
        ExecutorService executorService = (ExecutorService)eventsCmd.exec();
        this.generateEvents();
        boolean zeroCount = countDownLatch.await(5L, TimeUnit.SECONDS);
        executorService.shutdown();
        EventsCmdImplTest.assertTrue((boolean)zeroCount, (String)"Expected 4 events, [create, start, die, stop]");
    }

    private int generateEvents() {
        String testImage = "busybox";
        this.asString((InputStream)this.dockerClient.pullImageCmd(testImage).exec());
        CreateContainerResponse container = this.dockerClient.createContainerCmd(testImage).withCmd(new String[]{"echo"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.stopContainerCmd(container.getId()).exec();
        return KNOWN_NUM_EVENTS;
    }

    private class EventCallbackTest
    implements EventCallback {
        private final CountDownLatch countDownLatch;

        public EventCallbackTest(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onEvent(Event event) {
            AbstractDockerClientTest.LOG.info("Received event #{}: {}", (Object)this.countDownLatch.getCount(), (Object)event);
            this.countDownLatch.countDown();
        }

        public void onException(Throwable throwable) {
            AbstractDockerClientTest.LOG.error("Error occurred: {}", (Object)throwable.getMessage());
        }

        public void onCompletion(int numEvents) {
            AbstractDockerClientTest.LOG.info("Number of events received: {}", (Object)numEvents);
        }
    }
}

