/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ListImagesCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void listImages() throws DockerException {
        List images = (List)this.dockerClient.listImagesCmd().withShowAll(true).exec();
        MatcherAssert.assertThat((Object)images, (Matcher)Matchers.notNullValue());
        LOG.info("Images List: {}", (Object)images);
        Info info = (Info)this.dockerClient.infoCmd().exec();
        MatcherAssert.assertThat((Object)images.size(), (Matcher)Matchers.equalTo((Object)info.getImages()));
        Image img = (Image)images.get(0);
        MatcherAssert.assertThat((Object)img.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getVirtualSize(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        MatcherAssert.assertThat((Object)img.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)img.getRepoTags(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }
}

