/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.InternalServerErrorException;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class PullImageCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testPullImage() throws DockerException, IOException {
        Info info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        int imgCount = info.getImages();
        LOG.info("imgCount1: {}", (Object)imgCount);
        String testImage = "hackmann/empty";
        LOG.info("Removing image: {}", (Object)testImage);
        this.dockerClient.removeImageCmd(testImage).exec();
        info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info: {}", (Object)info.toString());
        imgCount = info.getImages();
        LOG.info("imgCount2: {}", (Object)imgCount);
        LOG.info("Pulling image: {}", (Object)testImage);
        InputStream response = (InputStream)this.dockerClient.pullImageCmd(testImage).exec();
        MatcherAssert.assertThat((Object)this.asString(response), (Matcher)Matchers.containsString((String)"Download complete"));
        info = (Info)this.dockerClient.infoCmd().exec();
        LOG.info("Client info after pull, {}", (Object)info.toString());
        MatcherAssert.assertThat((Object)imgCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(info.getImages())));
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(testImage).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testPullNonExistingImage() throws DockerException, IOException {
        this.dockerClient.pullImageCmd("nonexisting/foo").exec();
        try {
            this.dockerClient.pullImageCmd("non-existing/foo").exec();
            PullImageCmdImplTest.fail((String)"expected InternalServerErrorException");
        }
        catch (InternalServerErrorException internalServerErrorException) {
            // empty catch block
        }
    }
}

