/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class PushImageCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(PushImageCmdImplTest.class);
    String username;

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
        this.username = this.dockerClient.authConfig().getUsername();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void pushLatest() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        LOG.info("Commiting container: {}", (Object)container.toString());
        String imageId = this.dockerClient.commitCmd(container.getId()).withRepository(this.username + "/busybox").exec();
        this.asString(this.dockerClient.pushImageCmd(this.username + "/busybox").exec());
        this.dockerClient.removeImageCmd(imageId).exec();
        String response = this.asString((InputStream)this.dockerClient.pullImageCmd(this.username + "/busybox").exec());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"HTTP code: 404")));
    }

    @Test
    public void pushExistentImage() throws Exception {
        MatcherAssert.assertThat((Object)this.asString(this.dockerClient.pushImageCmd(this.username + "/xxx").exec()), (Matcher)Matchers.containsString((String)"error"));
    }
}

