/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RemoveContainerCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveContainerCmdImplTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void removeContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.waitContainerCmd(container.getId()).exec();
        LOG.info("Removing container: {}", (Object)container.getId());
        this.dockerClient.removeContainerCmd(container.getId()).exec();
        List containers2 = (List)this.dockerClient.listContainersCmd().withShowAll(true).exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container.getId()))));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
    }

    @Test
    public void removeNonExistingContainer() throws DockerException {
        try {
            this.dockerClient.removeContainerCmd("non-existing").exec();
            RemoveContainerCmdImplTest.fail((String)"expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

