/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RemoveImageCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveImageCmdImplTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void removeImage() throws DockerException, InterruptedException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        LOG.info("Commiting container {}", (Object)container.toString());
        String imageId = this.dockerClient.commitCmd(container.getId()).exec();
        this.dockerClient.stopContainerCmd(container.getId()).exec();
        this.dockerClient.killContainerCmd(container.getId()).exec();
        this.dockerClient.removeContainerCmd(container.getId()).exec();
        LOG.info("Removing image: {}", (Object)imageId);
        this.dockerClient.removeImageCmd(imageId).exec();
        List containers = (List)this.dockerClient.listContainersCmd().withShowAll(true).exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)imageId))));
        MatcherAssert.assertThat((Object)containers, (Matcher)matcher);
    }

    @Test
    public void removeNonExistingImage() throws DockerException, InterruptedException {
        try {
            this.dockerClient.removeImageCmd("non-existing").exec();
            RemoveImageCmdImplTest.fail((String)"expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

