/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class StartContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void startContainerWithVolumes() throws DockerException {
        Volume volume1 = new Volume("/opt/webapp1");
        Volume volume2 = new Volume("/opt/webapp2");
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withVolumes(new Volume[]{volume1, volume2}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/opt/webapp1", "/opt/webapp2"}));
        this.dockerClient.startContainerCmd(container.getId()).withBinds(new Bind[]{new Bind("/src/webapp1", volume1, true), new Bind("/src/webapp2", volume2)}).exec();
        this.dockerClient.waitContainerCmd(container.getId()).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        VolumeBind[] volumeBinds = inspectContainerResponse.getVolumes();
        ArrayList<String> volumes = new ArrayList<String>();
        for (VolumeBind bind : volumeBinds) {
            volumes.add(bind.getContainerPath());
        }
        MatcherAssert.assertThat(volumes, (Matcher)Matchers.contains((Object[])new String[]{volume1.getPath(), volume2.getPath()}));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getVolumesRW()), (Matcher)Matchers.contains((Object[])new Volume[]{volume1, volume2}));
    }

    @Test
    public void startContainerWithDns() throws DockerException {
        String aDnsServer = "8.8.8.8";
        String anotherDnsServer = "8.8.4.4";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withDns(new String[]{aDnsServer, anotherDnsServer}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).withDns(new String[]{aDnsServer, anotherDnsServer}).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDns()), (Matcher)Matchers.contains((Object[])new String[]{aDnsServer, anotherDnsServer}));
    }

    @Test
    public void startContainerWithDnsSearch() throws DockerException {
        String dnsSearch = "example.com";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).withDnsSearch(new String[]{dnsSearch}).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDnsSearch()), (Matcher)Matchers.contains((Object[])new String[]{dnsSearch}));
    }

    @Test
    public void startContainerWithPortBindings() throws DockerException {
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding((int)11022));
        portBindings.bind(tcp23, Ports.Binding((int)11023));
        this.dockerClient.startContainerCmd(container.getId()).withPortBindings(portBindings).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getExposedPorts()), (Matcher)Matchers.contains((Object[])new ExposedPort[]{tcp22, tcp23}));
        MatcherAssert.assertThat(inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp22), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding((int)11022))));
        MatcherAssert.assertThat(inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding((int)11023))));
    }

    @Test
    public void startContainerWithLinking() throws DockerException {
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.startsWith((String)container1.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getName(), (Matcher)Matchers.equalTo((Object)"/container1"));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().isRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse1.getState().isRunning()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withName("container2").exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container2.getId()).withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        LOG.info("Container2 Inspect: {}", (Object)inspectContainerResponse2.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new String[]{"/container1:/container2/container1Link"}));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.startsWith((String)container2.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getName(), (Matcher)Matchers.equalTo((Object)"/container2"));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState().isRunning(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void startContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getId(), (Matcher)Matchers.startsWith((String)container.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().isRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse.getState().isRunning()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
    }

    @Test
    public void testStartNonExistingContainer() throws DockerException {
        try {
            this.dockerClient.startContainerCmd("non-existing").exec();
            StartContainerCmdImplTest.fail((String)"expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void startContainerWithNetworkMode() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).withNetworkMode("host").exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNetworkMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void startContainerWithCapAddAndCapDrop() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).withCapAdd(new String[]{"NET_ADMIN"}).withCapDrop(new String[]{"MKNOD"}).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().isRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapAdd()), (Matcher)Matchers.contains((Object[])new String[]{"NET_ADMIN"}));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapDrop()), (Matcher)Matchers.contains((Object[])new String[]{"MKNOD"}));
    }

    @Test
    public void startContainerWithDevices() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).withDevices(new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().isRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDevices()), (Matcher)Matchers.contains((Object[])new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}));
    }

    @Test
    public void startContainerWithRestartPolicy() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        RestartPolicy restartPolicy = RestartPolicy.onFailureRestart((int)5);
        this.dockerClient.startContainerCmd(container.getId()).withRestartPolicy(restartPolicy).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().isRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getRestartPolicy(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)restartPolicy)));
    }
}

