/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.InternalServerErrorException;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class WaitContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws DockerException {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testWaitContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerClient.waitContainerCmd(container.getId()).exec();
        LOG.info("Container exit code: {}", (Object)exitCode);
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().isRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)exitCode)));
    }

    @Test
    public void testWaitNonExistingContainer() throws DockerException {
        try {
            this.dockerClient.waitContainerCmd("non-existing").exec();
            WaitContainerCmdImplTest.fail((String)"expected InternalServerErrorException");
        }
        catch (InternalServerErrorException internalServerErrorException) {
            // empty catch block
        }
    }
}

