/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class RestartPolicy {
    @JsonProperty(value="MaximumRetryCount")
    private int maximumRetryCount = 0;
    @JsonProperty(value="Name")
    private String name = "no";

    public RestartPolicy() {
    }

    private RestartPolicy(int maximumRetryCount, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.maximumRetryCount = maximumRetryCount;
        this.name = name;
    }

    public static RestartPolicy noRestart() {
        return new RestartPolicy();
    }

    public static RestartPolicy alwaysRestart() {
        return new RestartPolicy(0, "always");
    }

    public static RestartPolicy onFailureRestart(int maximumRetryCount) {
        return new RestartPolicy(maximumRetryCount, "on-failure");
    }

    public int getMaximumRetryCount() {
        return this.maximumRetryCount;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RestartPolicy) {
            RestartPolicy other = (RestartPolicy)obj;
            return new EqualsBuilder().append(this.maximumRetryCount, other.getMaximumRetryCount()).append((Object)this.name, (Object)other.getName()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.maximumRetryCount).append((Object)this.name).toHashCode();
    }
}

