/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import java.util.ServiceLoader;

public class DockerClientBuilder {
    private static ServiceLoader<DockerCmdExecFactory> serviceLoader = ServiceLoader.load(DockerCmdExecFactory.class);
    private DockerClientImpl dockerClient = null;

    private DockerClientBuilder(DockerClientImpl dockerClient) {
        this.dockerClient = dockerClient;
    }

    public static DockerClientBuilder getInstance() {
        return new DockerClientBuilder(DockerClientBuilder.withDefaultDockerCmdExecFactory(DockerClientImpl.getInstance()));
    }

    public static DockerClientBuilder getInstance(DockerClientConfig dockerClientConfig) {
        return new DockerClientBuilder(DockerClientBuilder.withDefaultDockerCmdExecFactory(DockerClientImpl.getInstance(dockerClientConfig)));
    }

    public static DockerClientBuilder getInstance(String serverUrl) {
        return new DockerClientBuilder(DockerClientBuilder.withDefaultDockerCmdExecFactory(DockerClientImpl.getInstance(serverUrl)));
    }

    private static DockerClientImpl withDefaultDockerCmdExecFactory(DockerClientImpl dockerClient) {
        DockerCmdExecFactory dockerCmdExecFactory = DockerClientBuilder.getDefaultDockerCmdExecFactory();
        return dockerClient.withDockerCmdExecFactory(dockerCmdExecFactory);
    }

    public static DockerCmdExecFactory getDefaultDockerCmdExecFactory() {
        if (!serviceLoader.iterator().hasNext()) {
            throw new RuntimeException("Fatal: Can't find any implementation of '" + DockerCmdExecFactory.class.getName() + "' in the current classpath.");
        }
        return serviceLoader.iterator().next();
    }

    public DockerClientBuilder withDockerCmdExecFactory(DockerCmdExecFactory dockerCmdExecFactory) {
        this.dockerClient = this.dockerClient.withDockerCmdExecFactory(dockerCmdExecFactory);
        return this;
    }

    public DockerClient build() {
        return this.dockerClient;
    }
}

