/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;

public class DockerClientConfig {
    private final URI uri;
    private final String version;
    private final String username;
    private final String password;
    private final String email;
    private final Integer readTimeout;
    private final boolean loggingFilterEnabled;

    private DockerClientConfig(DockerClientConfigBuilder builder) {
        this.uri = builder.uri;
        this.version = builder.version;
        this.username = builder.username;
        this.password = builder.password;
        this.email = builder.email;
        this.readTimeout = builder.readTimeout;
        this.loggingFilterEnabled = builder.loggingFilterEnabled;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isLoggingFilterEnabled() {
        return this.loggingFilterEnabled;
    }

    public static Properties loadIncludedDockerProperties() {
        try {
            Properties p = new Properties();
            p.load(DockerClientConfig.class.getResourceAsStream("/docker.io.properties"));
            return p;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties overrideDockerPropertiesWithSettingsFromUserHome(Properties p) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        File usersDockerPropertiesFile = new File(System.getProperty("user.home"), ".docker.io.properties");
        if (usersDockerPropertiesFile.isFile()) {
            try {
                FileInputStream in = new FileInputStream(usersDockerPropertiesFile);
                try {
                    overriddenProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return overriddenProperties;
    }

    public static Properties overrideDockerPropertiesWithSystemProperties(Properties p) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        for (String s : new String[]{"url", "version", "username", "password", "email", "readTimeout", "enableLoggingFilter"}) {
            String key = "docker.io." + s;
            if (!System.getProperties().containsKey(key)) continue;
            overriddenProperties.setProperty(key, System.getProperty(key));
        }
        return overriddenProperties;
    }

    public static DockerClientConfigBuilder createDefaultConfigBuilder() {
        Properties properties = DockerClientConfig.loadIncludedDockerProperties();
        properties = DockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties);
        properties = DockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties);
        return new DockerClientConfigBuilder().withProperties(properties);
    }

    public static class DockerClientConfigBuilder {
        private URI uri;
        private String version;
        private String username;
        private String password;
        private String email;
        private Integer readTimeout;
        private boolean loggingFilterEnabled;

        public DockerClientConfigBuilder withProperties(Properties p) {
            return this.withUri(p.getProperty("docker.io.url")).withVersion(p.getProperty("docker.io.version")).withUsername(p.getProperty("docker.io.username")).withPassword(p.getProperty("docker.io.password")).withEmail(p.getProperty("docker.io.email")).withReadTimeout(Integer.valueOf(p.getProperty("docker.io.readTimeout", "0"))).withLoggingFilter(Boolean.valueOf(p.getProperty("docker.io.enableLoggingFilter", "true")));
        }

        public final DockerClientConfigBuilder withUri(String uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri was not specified");
            this.uri = URI.create(uri);
            return this;
        }

        public final DockerClientConfigBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public final DockerClientConfigBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public final DockerClientConfigBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public final DockerClientConfigBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        public final DockerClientConfigBuilder withReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public final DockerClientConfigBuilder withLoggingFilter(boolean loggingFilterEnabled) {
            this.loggingFilterEnabled = loggingFilterEnabled;
            return this;
        }

        public DockerClientConfig build() {
            return new DockerClientConfig(this);
        }
    }
}

