/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.ConflictException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CreateContainerCmdImpl
extends AbstrDockerCmd<CreateContainerCmd, CreateContainerResponse>
implements CreateContainerCmd {
    private String name;
    @JsonProperty(value="Hostname")
    private String hostName = "";
    @JsonProperty(value="User")
    private String user = "";
    @JsonProperty(value="Memory")
    private long memoryLimit = 0L;
    @JsonProperty(value="MemorySwap")
    private long memorySwap = 0L;
    @JsonProperty(value="CpuShares")
    private int cpuShares = 0;
    @JsonProperty(value="AttachStdin")
    private boolean attachStdin = false;
    @JsonProperty(value="AttachStdout")
    private boolean attachStdout = false;
    @JsonProperty(value="AttachStderr")
    private boolean attachStderr = false;
    @JsonProperty(value="PortSpecs")
    private String[] portSpecs;
    @JsonProperty(value="Tty")
    private boolean tty = false;
    @JsonProperty(value="OpenStdin")
    private boolean stdinOpen = false;
    @JsonProperty(value="StdinOnce")
    private boolean stdInOnce = false;
    @JsonProperty(value="Env")
    private String[] env;
    @JsonProperty(value="Cmd")
    private String[] cmd;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Volumes")
    private Volumes volumes = new Volumes(new Volume[0]);
    @JsonProperty(value="VolumesFrom")
    private String[] volumesFrom = new String[0];
    @JsonProperty(value="WorkingDir")
    private String workingDir = "";
    @JsonProperty(value="DisableNetwork")
    private boolean disableNetwork = false;
    @JsonProperty(value="ExposedPorts")
    private ExposedPorts exposedPorts = new ExposedPorts(new ExposedPort[0]);

    public CreateContainerCmdImpl(CreateContainerCmd.Exec exec, String image) {
        super(exec);
        Preconditions.checkNotNull((Object)image, (Object)"image was not specified");
        this.withImage(image);
    }

    @Override
    public CreateContainerCmdImpl withName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name was not specified");
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CreateContainerCmdImpl withExposedPorts(ExposedPort ... exposedPorts) {
        this.exposedPorts = new ExposedPorts(exposedPorts);
        return this;
    }

    @Override
    @JsonIgnore
    public ExposedPort[] getExposedPorts() {
        return this.exposedPorts.getExposedPorts();
    }

    @Override
    public boolean isDisableNetwork() {
        return this.disableNetwork;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public CreateContainerCmdImpl withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public CreateContainerCmdImpl withDisableNetwork(boolean disableNetwork) {
        this.disableNetwork = disableNetwork;
        return this;
    }

    @Override
    public CreateContainerCmdImpl withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @Override
    public String[] getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    public CreateContainerCmdImpl withPortSpecs(String ... portSpecs) {
        this.portSpecs = portSpecs;
        return this;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public CreateContainerCmdImpl withUser(String user) {
        this.user = user;
        return this;
    }

    @Override
    public boolean isTty() {
        return this.tty;
    }

    @Override
    public CreateContainerCmdImpl withTty(boolean tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public boolean isStdinOpen() {
        return this.stdinOpen;
    }

    @Override
    public CreateContainerCmdImpl withStdinOpen(boolean stdinOpen) {
        this.stdinOpen = stdinOpen;
        return this;
    }

    @Override
    public boolean isStdInOnce() {
        return this.stdInOnce;
    }

    @Override
    public CreateContainerCmdImpl withStdInOnce(boolean stdInOnce) {
        this.stdInOnce = stdInOnce;
        return this;
    }

    @Override
    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public CreateContainerCmdImpl withMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    @Override
    public long getMemorySwap() {
        return this.memorySwap;
    }

    @Override
    public CreateContainerCmdImpl withMemorySwap(long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    @Override
    public int getCpuShares() {
        return this.cpuShares;
    }

    @Override
    public CreateContainerCmdImpl withCpuShares(int cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    @Override
    public boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public CreateContainerCmdImpl withAttachStdin(boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    @Override
    public boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public CreateContainerCmdImpl withAttachStdout(boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    @Override
    public boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public CreateContainerCmdImpl withAttachStderr(boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    @Override
    public String[] getEnv() {
        return this.env;
    }

    @Override
    public CreateContainerCmdImpl withEnv(String ... env) {
        this.env = env;
        return this;
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    @Override
    public CreateContainerCmdImpl withCmd(String ... cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    public String[] getDns() {
        return this.dns;
    }

    @Override
    public CreateContainerCmdImpl withDns(String ... dns) {
        this.dns = dns;
        return this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public CreateContainerCmdImpl withImage(String image) {
        this.image = image;
        return this;
    }

    @Override
    @JsonIgnore
    public Volume[] getVolumes() {
        return this.volumes.getVolumes();
    }

    @Override
    public CreateContainerCmdImpl withVolumes(Volume ... volumes) {
        this.volumes = new Volumes(volumes);
        return this;
    }

    @Override
    public String[] getVolumesFrom() {
        return this.volumesFrom;
    }

    @Override
    public CreateContainerCmdImpl withVolumesFrom(String ... volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)"create container ").append((Object)(this.name != null ? "name=" + this.name + " " : "")).append((Object)this).toString();
    }

    @Override
    public CreateContainerResponse exec() throws NotFoundException, ConflictException {
        return (CreateContainerResponse)super.exec();
    }
}

