/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.EventCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.jaxrs.AbstrDockerCmdExec;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCmdExec
extends AbstrDockerCmdExec<EventsCmd, ExecutorService>
implements EventsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCmdExec.class);

    public EventsCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected ExecutorService execute(EventsCmd command) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        WebTarget webResource = this.getBaseResource().path("/events").queryParam("since", new Object[]{command.getSince()}).queryParam("until", new Object[]{command.getUntil()});
        LOGGER.trace("GET: {}", (Object)webResource);
        EventNotifier eventNotifier = EventNotifier.create(command.getEventCallback(), webResource);
        executorService.submit(eventNotifier);
        return executorService;
    }

    private static class EventNotifier
    implements Callable<Void> {
        private static final JsonFactory JSON_FACTORY = new JsonFactory();
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private final EventCallback eventCallback;
        private final WebTarget webTarget;

        private EventNotifier(EventCallback eventCallback, WebTarget webTarget) {
            this.eventCallback = eventCallback;
            this.webTarget = webTarget;
        }

        public static EventNotifier create(EventCallback eventCallback, WebTarget webTarget) {
            Preconditions.checkNotNull((Object)eventCallback, (Object)"An EventCallback must be provided");
            Preconditions.checkNotNull((Object)webTarget, (Object)"An WebTarget must be provided");
            return new EventNotifier(eventCallback, webTarget);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            int numEvents = 0;
            Response response = null;
            try {
                response = (Response)this.webTarget.request().get(Response.class);
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                JsonParser jp = JSON_FACTORY.createParser(inputStream);
                while (jp.nextToken() != JsonToken.END_OBJECT && !jp.isClosed()) {
                    this.eventCallback.onEvent((Event)OBJECT_MAPPER.readValue(jp, Event.class));
                    ++numEvents;
                }
            }
            catch (Exception e) {
                this.eventCallback.onException(e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            this.eventCallback.onCompletion(numEvents);
            return null;
        }
    }
}

