/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.jaxrs.AbstrDockerCmdExec;
import java.io.InputStream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushImageCmdExec
extends AbstrDockerCmdExec<PushImageCmd, InputStream>
implements PushImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushImageCmdExec.class);

    public PushImageCmdExec(WebTarget baseResource) {
        super(baseResource);
    }

    @Override
    protected InputStream execute(PushImageCmd command) {
        WebTarget webResource = this.getBaseResource().path("/images/" + this.name(command) + "/push");
        String registryAuth = this.registryAuth(command.getAuthConfig());
        LOGGER.trace("POST: {}", (Object)webResource);
        return (InputStream)webResource.request().header("X-Registry-Auth", (Object)registryAuth).accept(new String[]{"application/json"}).post(Entity.entity(Response.class, (String)"application/json")).readEntity(InputStream.class);
    }

    private String name(PushImageCmd command) {
        String name = command.getName();
        AuthConfig authConfig = command.getAuthConfig();
        return name.contains("/") ? name : authConfig.getUsername();
    }
}

