/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api;

import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.DockerObjectAccessor;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.object.IsCompatibleType;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsSerializableTest {
    private static final Logger LOG = LoggerFactory.getLogger(ModelsSerializableTest.class);
    private List<String> excludeClasses = Arrays.asList(Binds.class.getName(), BuildResponseItem.class.getName(), PullResponseItem.class.getName(), PushResponseItem.class.getName(), ResponseItem.class.getName(), ResponseItem.ErrorDetail.class.getName(), ResponseItem.ProgressDetail.class.getName());

    @Test
    public void allModelsSerializable() throws IOException, NoSuchFieldException, IllegalAccessException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)contextClassLoader).getAllClasses()) {
            Class aClass;
            if (!classInfo.getPackageName().equals("com.github.dockerjava.api.model") || classInfo.getName().endsWith("Test") || DockerObject.class.getName().equals(classInfo.getName()) || DockerObjectAccessor.class.getName().equals(classInfo.getName()) || (aClass = classInfo.load()).getProtectionDomain().getCodeSource().getLocation().getPath().endsWith("test-classes/") || aClass.isEnum()) continue;
            LOG.debug("Checking: {}", (Object)aClass);
            MatcherAssert.assertThat((Object)aClass, (Matcher)IsCompatibleType.typeCompatibleWith(Serializable.class));
            Object serialVersionUID = FieldUtils.readDeclaredStaticField((Class)aClass, (String)"serialVersionUID", (boolean)true);
            if (this.excludeClasses.contains(aClass.getName())) continue;
            MatcherAssert.assertThat((Object)serialVersionUID, (Matcher)Matchers.instanceOf(Long.class));
            MatcherAssert.assertThat((String)("Follow devel docs for " + aClass), (Object)((Long)serialVersionUID), (Matcher)Matchers.is((Object)1L));
        }
    }
}

