/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.command.CommandJSONSamples;
import com.github.dockerjava.api.command.GraphData;
import com.github.dockerjava.api.command.HealthStateLog;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Isolation;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class InspectContainerResponseTest {
    @Test
    public void roundTrip_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full, InspectContainerResponse[].class);
        Assert.assertEquals((long)1L, (long)responses.length);
        InspectContainerResponse response = responses[0];
        Assert.assertEquals((long)response.getVolumes().length, (long)2L);
        Assert.assertEquals((long)response.getVolumesRW().length, (long)2L);
        Assert.assertEquals((Object)response.getVolumes()[1].getContainerPath(), (Object)"/bar/foo/myvol2");
        Assert.assertEquals((Object)response.getVolumes()[1].getHostPath(), (Object)"/path2");
        Assert.assertEquals((Object)response.getVolumesRW()[1].getVolume().getPath(), (Object)"/bar/foo/myvol2");
        Assert.assertFalse((boolean)response.getVolumesRW()[1].getAccessMode().toBoolean());
        Assert.assertTrue((boolean)response.getVolumesRW()[0].getAccessMode().toBoolean());
        MatcherAssert.assertThat((Object)response.getLogPath(), (Matcher)Matchers.is((Object)"/mnt/sda1/var/lib/docker/containers/469e5edd8d5b33e3c905a7ffc97360ec6ee211d6782815fbcd144568045819e1/469e5edd8d5b33e3c905a7ffc97360ec6ee211d6782815fbcd144568045819e1-json.log"));
    }

    @Test
    public void roundTrip_full_healthcheck() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectContainerResponse.class);
        InspectContainerResponse response = (InspectContainerResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_24, "/containers/inspect/1.json", type);
        Assert.assertEquals((Object)response.getState().getHealth().getStatus(), (Object)"healthy");
        Assert.assertEquals((Object)response.getState().getHealth().getFailingStreak(), (Object)new Integer(0));
        Assert.assertEquals((long)response.getState().getHealth().getLog().size(), (long)2L);
        Assert.assertEquals((Object)((HealthStateLog)response.getState().getHealth().getLog().get(0)).getOutput(), (Object)"Hello");
        Assert.assertEquals((Object)((HealthStateLog)response.getState().getHealth().getLog().get(1)).getOutput(), (Object)"World");
    }

    @Test
    public void roundTrip_1_21_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full_1_21, InspectContainerResponse[].class);
        Assert.assertEquals((long)1L, (long)responses.length);
        InspectContainerResponse response = responses[0];
        InspectContainerResponse.ContainerState state = response.getState();
        MatcherAssert.assertThat((Object)state, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
        Assert.assertFalse((boolean)state.getDead());
        MatcherAssert.assertThat((Object)state.getStatus(), (Matcher)Matchers.containsString((String)"running"));
        Assert.assertFalse((boolean)state.getRestarting());
        Assert.assertFalse((boolean)state.getOOMKilled());
        MatcherAssert.assertThat((Object)state.getError(), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
    }

    @Test
    public void roundTrip_1_26a_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full_1_26a, InspectContainerResponse[].class);
        Assert.assertEquals((long)1L, (long)responses.length);
        InspectContainerResponse response = responses[0];
        List mounts = response.getMounts();
        Assert.assertEquals((long)mounts.size(), (long)1L);
        InspectContainerResponse.Mount mount = (InspectContainerResponse.Mount)mounts.get(0);
        Volume volume = mount.getDestination();
        Assert.assertEquals((Object)volume.getPath(), (Object)"/var/lib/postgresql/data");
    }

    @Test
    public void roundTrip_1_26b_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full_1_26b, InspectContainerResponse[].class);
        Assert.assertEquals((long)1L, (long)responses.length);
        InspectContainerResponse response = responses[0];
        List mounts = response.getMounts();
        Assert.assertEquals((long)mounts.size(), (long)1L);
        InspectContainerResponse.Mount mount = (InspectContainerResponse.Mount)mounts.get(0);
        Volume volume = mount.getDestination();
        Assert.assertEquals((Object)volume.getPath(), (Object)"/srv/test");
    }

    @Test
    public void roundTrip_empty() throws IOException {
        JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_empty, InspectContainerResponse[].class);
    }

    @Test
    public void inspect_windows_container() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectContainerResponse.class);
        InspectContainerResponse response = (InspectContainerResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_38, "/containers/inspect/lcow.json", type);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getConfig(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getConfig().getCmd(), (Matcher)Matchers.is((Object)new String[]{"cmd"}));
        MatcherAssert.assertThat((Object)response.getConfig().getImage(), (Matcher)Matchers.is((Object)"microsoft/nanoserver"));
        MatcherAssert.assertThat((Object)response.getDriver(), (Matcher)Matchers.is((Object)"windowsfilter"));
        MatcherAssert.assertThat((Object)response.getGraphDriver(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getGraphDriver().getName(), (Matcher)Matchers.is((Object)"windowsfilter"));
        MatcherAssert.assertThat((Object)response.getGraphDriver().getData(), (Matcher)Matchers.is((Object)new GraphData().withDir("C:\\ProgramData\\Docker\\windowsfilter\\35da02ca897bd378ee52be3066c847fee396ba1a28a00b4be36f42c6686bf556")));
        MatcherAssert.assertThat((Object)response.getHostConfig(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getHostConfig().getIsolation(), (Matcher)Matchers.is((Object)Isolation.HYPERV));
        MatcherAssert.assertThat((Object)response.getImageId(), (Matcher)Matchers.is((Object)"sha256:1381511ec0122f197b6abff5bc0692bef19943ddafd6680eff41197afa3a6dda"));
        MatcherAssert.assertThat((Object)response.getLogPath(), (Matcher)Matchers.is((Object)"C:\\ProgramData\\Docker\\containers\\35da02ca897bd378ee52be3066c847fee396ba1a28a00b4be36f42c6686bf556\\35da02ca897bd378ee52be3066c847fee396ba1a28a00b4be36f42c6686bf556-json.log"));
        MatcherAssert.assertThat((Object)response.getName(), (Matcher)Matchers.is((Object)"/cranky_clarke"));
        MatcherAssert.assertThat((Object)response.getNetworkSettings(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getNetworkSettings().getNetworks(), (Matcher)Matchers.is(Collections.singletonMap("nat", new ContainerNetwork().withEndpointId("493b77d6fe7e3b92435b1eb01461fde669781330deb84a9cbada360db8997ebc").withGateway("172.17.18.1").withGlobalIPv6Address("").withGlobalIPv6PrefixLen(Integer.valueOf(0)).withIpv4Address("172.17.18.123").withIpPrefixLen(Integer.valueOf(16)).withIpV6Gateway("").withMacAddress("00:aa:ff:cf:dd:09").withNetworkID("398c0e206dd677ed4a6566f9de458311f5767d8c7a8b963275490ab64c5d10a7"))));
        MatcherAssert.assertThat((Object)response.getPath(), (Matcher)Matchers.is((Object)"cmd"));
        MatcherAssert.assertThat((Object)response.getPlatform(), (Matcher)Matchers.is((Object)"windows"));
    }

    @Test
    public void equals() {
        MatcherAssert.assertThat((Object)new InspectContainerResponse(), (Matcher)Matchers.equalTo((Object)new InspectContainerResponse()));
    }
}

