/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Test;

public class InspectExecResponseTest {
    @Test
    public void test_1_22_SerDer1() throws Exception {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectExecResponse.class);
        InspectExecResponse execResponse = (InspectExecResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/exec/ID/1.json", type);
        MatcherAssert.assertThat((Object)execResponse, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)execResponse.getId(), (Matcher)Matchers.is((Object)"1ca2ca598fab202f86dd9281196c405456069013958a475396b707e85c56473b"));
        MatcherAssert.assertThat((Object)execResponse.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)execResponse.getExitCode(), (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
        InspectExecResponse.ProcessConfig processConfig = execResponse.getProcessConfig();
        MatcherAssert.assertThat((Object)processConfig, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)processConfig.isTty(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)processConfig.getEntryPoint(), (Matcher)Matchers.is((Object)"/bin/bash"));
        MatcherAssert.assertThat((Object)processConfig.getArguments(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)processConfig.isPrivileged(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)processConfig.getUser(), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
        MatcherAssert.assertThat((Object)execResponse.isOpenStdin(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)execResponse.isOpenStderr(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)execResponse.isOpenStdout(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)execResponse.getCanRemove(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)execResponse.getContainerID(), (Matcher)Matchers.is((Object)"ffa39805f089af3099e36452a985481f96170a9dff40be69d34d1722c7660d38"));
        MatcherAssert.assertThat((Object)execResponse.getDetachKeys(), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
    }
}

