/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.command.GraphData;
import com.github.dockerjava.api.command.GraphDriver;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class InspectImageResponseTest {
    @Test
    public void serder1_22Json() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectImageResponse.class);
        InspectImageResponse inspectImage = (InspectImageResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "images/image1/inspect1.json", type);
        ContainerConfig config = new ContainerConfig().withAttachStderr(Boolean.valueOf(false)).withAttachStdin(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(false)).withCmd(null).withDomainName("").withEntrypoint(null).withEnv(new String[]{"HOME=/", "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"}).withExposedPorts(null).withHostName("aee9ba801acc").withImage("511136ea3c5a64f264b78b5433614aec563103b4d4702f3ba7d4d2698e22c158").withLabels(null).withMacAddress(null).withNetworkDisabled(null).withOnBuild(new String[0]).withStdinOpen(Boolean.valueOf(false)).withPortSpecs(null).withStdInOnce(Boolean.valueOf(false)).withTty(Boolean.valueOf(false)).withUser("").withVolumes(null).withWorkingDir("");
        ContainerConfig containerConfig = new ContainerConfig().withAttachStderr(Boolean.valueOf(false)).withAttachStdin(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(false)).withCmd(new String[]{"/bin/sh", "-c", "#(nop) MAINTAINER hack@worldticket.net"}).withDomainName("").withEntrypoint(null).withEnv(new String[]{"HOME=/", "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"}).withExposedPorts(null).withHostName("aee9ba801acc").withImage("511136ea3c5a64f264b78b5433614aec563103b4d4702f3ba7d4d2698e22c158").withLabels(null).withMacAddress(null).withNetworkDisabled(null).withOnBuild(new String[0]).withStdinOpen(Boolean.valueOf(false)).withPortSpecs(null).withStdInOnce(Boolean.valueOf(false)).withTty(Boolean.valueOf(false)).withUser("").withVolumes(null).withWorkingDir("");
        MatcherAssert.assertThat((Object)inspectImage, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getArch(), (Matcher)Matchers.is((Object)"amd64"));
        MatcherAssert.assertThat((Object)inspectImage.getAuthor(), (Matcher)Matchers.is((Object)"hack@worldticket.net"));
        MatcherAssert.assertThat((Object)inspectImage.getComment(), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
        MatcherAssert.assertThat((Object)inspectImage.getConfig(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getConfig(), (Matcher)Matchers.equalTo((Object)config));
        MatcherAssert.assertThat((Object)inspectImage.getCreated(), (Matcher)Matchers.is((Object)"2014-04-29T19:59:10.84997669Z"));
        MatcherAssert.assertThat((Object)inspectImage.getContainer(), (Matcher)Matchers.is((Object)"aee9ba801acca0e648ffd91df204ba82ae85d97608a4864a019e2004d7e1b133"));
        MatcherAssert.assertThat((Object)inspectImage.getContainerConfig(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getContainerConfig(), (Matcher)Matchers.equalTo((Object)containerConfig));
        MatcherAssert.assertThat((Object)inspectImage.getDockerVersion(), (Matcher)Matchers.is((Object)"0.8.1"));
        MatcherAssert.assertThat((Object)inspectImage.getId(), (Matcher)Matchers.is((Object)"sha256:ee45fe0d1fcdf1a0f9c2d1e36c6f4b3202bbb2032f14d7c9312b27bfcf6aee24"));
        MatcherAssert.assertThat((Object)inspectImage.getOs(), (Matcher)Matchers.is((Object)"linux"));
        MatcherAssert.assertThat((Object)inspectImage.getParent(), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
        MatcherAssert.assertThat((Object)inspectImage.getSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.hasItem((Object)"hackmann/empty:latest"));
        GraphDriver aufsGraphDriver = new GraphDriver().withName("aufs");
        GraphDriver graphDriver = inspectImage.getGraphDriver();
        MatcherAssert.assertThat((Object)graphDriver, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)graphDriver, (Matcher)Matchers.equalTo((Object)aufsGraphDriver));
        MatcherAssert.assertThat((Object)graphDriver.getName(), (Matcher)Matchers.is((Object)"aufs"));
        MatcherAssert.assertThat((Object)graphDriver.getData(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)inspectImage.getVirtualSize(), (Matcher)Matchers.is((Object)0L));
        InspectImageResponse inspectImageResponse = new InspectImageResponse().withArch("amd64").withAuthor("hack@worldticket.net").withComment("").withConfig(config).withContainer("aee9ba801acca0e648ffd91df204ba82ae85d97608a4864a019e2004d7e1b133").withContainerConfig(containerConfig).withCreated("2014-04-29T19:59:10.84997669Z").withDockerVersion("0.8.1").withId("sha256:ee45fe0d1fcdf1a0f9c2d1e36c6f4b3202bbb2032f14d7c9312b27bfcf6aee24").withOs("linux").withParent("").withSize(Long.valueOf(0L)).withRepoTags(Collections.singletonList("hackmann/empty:latest")).withRepoDigests(Collections.emptyList()).withVirtualSize(Long.valueOf(0L)).withGraphDriver(aufsGraphDriver);
        MatcherAssert.assertThat((Object)inspectImage, (Matcher)Matchers.equalTo((Object)inspectImageResponse));
    }

    @Test
    public void serder1_22_doc() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectImageResponse.class);
        InspectImageResponse inspectImage = (InspectImageResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "images/docImage/doc.json", type);
        MatcherAssert.assertThat((Object)inspectImage, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getRepoDigests(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)inspectImage.getRepoDigests(), (Matcher)Matchers.contains((Object[])new String[]{"localhost:5000/test/busybox/example@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf"}));
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"example:1.0", "example:latest", "example:stable"}));
    }

    @Test
    public void serder1_22_inspect_doc() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectImageResponse.class);
        InspectImageResponse inspectImage = (InspectImageResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "images/docImage/inspect_doc.json", type);
        GraphData newGraphData = new GraphData().withDeviceId("5").withDeviceName("docker-253:1-2763198-d2cc496561d6d520cbc0236b4ba88c362c446a7619992123f11c809cded25b47").withDeviceSize("171798691840");
        MatcherAssert.assertThat((Object)inspectImage, (Matcher)Matchers.notNullValue());
        GraphDriver graphDriver = inspectImage.getGraphDriver();
        MatcherAssert.assertThat((Object)graphDriver, (Matcher)Matchers.notNullValue());
        GraphData data = graphDriver.getData();
        MatcherAssert.assertThat((Object)data, (Matcher)Matchers.is((Object)newGraphData));
        MatcherAssert.assertThat((Object)data.getDeviceId(), (Matcher)Matchers.is((Object)"5"));
        MatcherAssert.assertThat((Object)data.getDeviceName(), (Matcher)Matchers.is((Object)"docker-253:1-2763198-d2cc496561d6d520cbc0236b4ba88c362c446a7619992123f11c809cded25b47"));
        MatcherAssert.assertThat((Object)data.getDeviceSize(), (Matcher)Matchers.is((Object)"171798691840"));
    }

    @Test
    public void testOverlayNetworkRootDir() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectImageResponse.class);
        InspectImageResponse inspectImage = (InspectImageResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "images/overlay/inspectOverlay.json", type);
        GraphData overlayGraphData = new GraphData().withRootDir("/var/lib/docker/overlay/7e8d362d6b78d47eafe4863fd129cbcada35dbd419d7188cc1dbf1233d505576/root");
        GraphDriver overlayGraphDriver = new GraphDriver().withName("overlay").withData(overlayGraphData);
        GraphDriver graphDriver = inspectImage.getGraphDriver();
        MatcherAssert.assertThat((Object)graphDriver, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)graphDriver, (Matcher)Matchers.equalTo((Object)overlayGraphDriver));
        MatcherAssert.assertThat((Object)graphDriver.getName(), (Matcher)Matchers.is((Object)"overlay"));
        MatcherAssert.assertThat((Object)graphDriver.getData(), (Matcher)Matchers.equalTo((Object)overlayGraphData));
    }

    @Test
    public void inspectWindowsImage() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(InspectImageResponse.class);
        InspectImageResponse inspectImage = (InspectImageResponse)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_25, "images/windowsImage/doc.json", type);
        MatcherAssert.assertThat((Object)inspectImage, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)inspectImage.getRepoTags(), (Matcher)Matchers.contains((Object[])new String[]{"microsoft/nanoserver:latest"}));
        MatcherAssert.assertThat((Object)inspectImage.getRepoDigests(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)inspectImage.getRepoDigests(), (Matcher)Matchers.contains((Object[])new String[]{"microsoft/nanoserver@sha256:aee7d4330fe3dc5987c808f647441c16ed2fa1c7d9c6ef49d6498e5c9860b50b"}));
        MatcherAssert.assertThat((Object)inspectImage.getConfig(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getConfig().getCmd(), (Matcher)Matchers.is((Object)new String[]{"c:\\windows\\system32\\cmd.exe"}));
        MatcherAssert.assertThat((Object)inspectImage.getOs(), (Matcher)Matchers.is((Object)"windows"));
        MatcherAssert.assertThat((Object)inspectImage.getOsVersion(), (Matcher)Matchers.is((Object)"10.0.14393"));
        MatcherAssert.assertThat((Object)inspectImage.getSize(), (Matcher)Matchers.is((Object)651862727L));
        MatcherAssert.assertThat((Object)inspectImage.getVirtualSize(), (Matcher)Matchers.is((Object)651862727L));
        MatcherAssert.assertThat((Object)inspectImage.getGraphDriver(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getGraphDriver().getName(), (Matcher)Matchers.is((Object)"windowsfilter"));
        MatcherAssert.assertThat((Object)inspectImage.getGraphDriver().getData(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getGraphDriver().getData().getDir(), (Matcher)Matchers.is((Object)"C:\\control\\windowsfilter\\6fe6a289b98276a6a5ca0345156ca61d7b38f3da6bb49ef95af1d0f1ac37e5bf"));
        MatcherAssert.assertThat((Object)inspectImage.getRootFS(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)inspectImage.getRootFS().getType(), (Matcher)Matchers.is((Object)"layers"));
        MatcherAssert.assertThat((Object)inspectImage.getRootFS().getLayers(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)inspectImage.getRootFS().getLayers(), (Matcher)Matchers.contains((Object[])new String[]{"sha256:342d4e407550c52261edd20cd901b5ce438f0b1e940336de3978210612365063"}));
    }
}

