/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AuthConfigTest {
    @Test
    public void defaultServerAddress() throws Exception {
        Assert.assertEquals((Object)new AuthConfig().getRegistryAddress(), (Object)"https://index.docker.io/v1/");
    }

    @Test
    public void serderDocs1() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/other/AuthConfig/docs1.json", type);
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getUsername(), (Matcher)CoreMatchers.is((Object)"jdoe"));
        MatcherAssert.assertThat((Object)authConfig.getPassword(), (Matcher)CoreMatchers.is((Object)"secret"));
        MatcherAssert.assertThat((Object)authConfig.getEmail(), (Matcher)CoreMatchers.is((Object)"jdoe@acme.com"));
        AuthConfig authConfig1 = new AuthConfig().withUsername("jdoe").withPassword("secret").withEmail("jdoe@acme.com");
        MatcherAssert.assertThat((Object)authConfig1, (Matcher)CoreMatchers.equalTo((Object)authConfig));
    }

    @Test
    public void serderDocs2() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/other/AuthConfig/docs2.json", type);
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getRegistrytoken(), (Matcher)CoreMatchers.is((Object)"9cbaf023786cd7..."));
        AuthConfig authConfig1 = new AuthConfig().withRegistrytoken("9cbaf023786cd7...");
        MatcherAssert.assertThat((Object)authConfig1, (Matcher)CoreMatchers.equalTo((Object)authConfig));
    }

    @Test
    public void compatibleWithIdentitytoken() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_23, "/other/AuthConfig/docs1.json", type);
        String auth = "YWRtaW46";
        String identitytoken = "1cba468e-8cbe-4c55-9098-2c2ed769e885";
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getAuth(), (Matcher)CoreMatchers.is((Object)auth));
        MatcherAssert.assertThat((Object)authConfig.getIdentitytoken(), (Matcher)CoreMatchers.is((Object)identitytoken));
        AuthConfig authConfig1 = new AuthConfig().withAuth(auth).withIdentityToken(identitytoken);
        MatcherAssert.assertThat((Object)authConfig1, (Matcher)CoreMatchers.equalTo((Object)authConfig));
    }

    @Test
    public void shouldNotFailWithStackOrchestratorInConfig() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(AuthConfig.class);
        AuthConfig authConfig = (AuthConfig)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_25, "/other/AuthConfig/orchestrators.json", type);
        MatcherAssert.assertThat((Object)authConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)authConfig.getAuth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)authConfig.getStackOrchestrator(), (Matcher)CoreMatchers.is((Object)"kubernetes"));
    }

    @Test
    public void toStringDoesNotContainSensitiveStrings() {
        AuthConfig authConfig = new AuthConfig().withAuth("authValue").withEmail("emailValue").withPassword("passwordValue").withIdentityToken("identityTokenValue").withRegistrytoken("registryTokenValue").withRegistryAddress("registryAddressValue");
        String toStringValue = authConfig.toString();
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"authValue")));
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"passwordValue")));
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"identityTokenValue")));
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"registryTokenValue")));
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)CoreMatchers.containsString((String)"emailValue"));
        MatcherAssert.assertThat((Object)toStringValue, (Matcher)CoreMatchers.containsString((String)"registryAddressValue"));
    }
}

