/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.PropagationMode;
import com.github.dockerjava.api.model.SELContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BindTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void parseUsingDefaultAccessMode() {
        Bind bind = Bind.parse((String)"/host:/container");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteNoCopyWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw,nocopy");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteSharedWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw,shared");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SHARED));
    }

    @Test
    public void parseReadWriteSlaveWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw,slave");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SLAVE));
    }

    @Test
    public void parseReadWritePrivateWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw,private");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.PRIVATE));
    }

    @Test
    public void parseReadOnlyWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:ro");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseSELOnlyWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
        bind = Bind.parse((String)"C:\\host:/container:z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteSELWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:rw,Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadOnlySELWindows() {
        Bind bind = Bind.parse((String)"C:\\host:/container:ro,z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"C:\\host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWrite() {
        Bind bind = Bind.parse((String)"/host:/container:rw");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteNoCopy() {
        Bind bind = Bind.parse((String)"/host:/container:rw,nocopy");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteShared() {
        Bind bind = Bind.parse((String)"/host:/container:rw,shared");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SHARED));
    }

    @Test
    public void parseReadWriteSlave() {
        Bind bind = Bind.parse((String)"/host:/container:rw,slave");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.SLAVE));
    }

    @Test
    public void parseReadWritePrivate() {
        Bind bind = Bind.parse((String)"/host:/container:rw,private");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.PRIVATE));
    }

    @Test
    public void parseReadOnly() {
        Bind bind = Bind.parse((String)"/host:/container:ro");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.none));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseSELOnly() {
        Bind bind = Bind.parse((String)"/host:/container:Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
        bind = Bind.parse((String)"/host:/container:z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.DEFAULT));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadWriteSEL() {
        Bind bind = Bind.parse((String)"/host:/container:rw,Z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.rw));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.single));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseReadOnlySEL() {
        Bind bind = Bind.parse((String)"/host:/container:ro,z");
        MatcherAssert.assertThat((Object)bind.getPath(), (Matcher)Is.is((Object)"/host"));
        MatcherAssert.assertThat((Object)bind.getVolume().getPath(), (Matcher)Is.is((Object)"/container"));
        MatcherAssert.assertThat((Object)bind.getAccessMode(), (Matcher)Is.is((Object)AccessMode.ro));
        MatcherAssert.assertThat((Object)bind.getSecMode(), (Matcher)Is.is((Object)SELContext.shared));
        MatcherAssert.assertThat((Object)bind.getNoCopy(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)bind.getPropagationMode(), (Matcher)Is.is((Object)PropagationMode.DEFAULT_MODE));
    }

    @Test
    public void parseInvalidAccessMode() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Bind");
        Bind.parse((String)"/host:/container:xx");
    }

    @Test
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Bind 'nonsense'");
        Bind.parse((String)"nonsense");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Bind 'null'");
        Bind.parse(null);
    }

    @Test
    public void toStringReadOnly() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro").toString(), (Matcher)Is.is((Object)"/host:/container:ro"));
    }

    @Test
    public void toStringReadWrite() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringReadWriteNoCopy() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,nocopy").toString(), (Matcher)Is.is((Object)"/host:/container:rw,nocopy"));
    }

    @Test
    public void toStringReadWriteShared() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,shared").toString(), (Matcher)Is.is((Object)"/host:/container:rw,shared"));
    }

    @Test
    public void toStringReadWriteSlave() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,slave").toString(), (Matcher)Is.is((Object)"/host:/container:rw,slave"));
    }

    @Test
    public void toStringReadWritePrivate() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,private").toString(), (Matcher)Is.is((Object)"/host:/container:rw,private"));
    }

    @Test
    public void toStringDefaultAccessMode() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container").toString(), (Matcher)Is.is((Object)"/host:/container:rw"));
    }

    @Test
    public void toStringReadOnlySEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:ro,Z").toString(), (Matcher)Is.is((Object)"/host:/container:ro,Z"));
    }

    @Test
    public void toStringReadWriteSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:rw,z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,z"));
    }

    @Test
    public void toStringDefaultSEL() {
        MatcherAssert.assertThat((Object)Bind.parse((String)"/host:/container:Z").toString(), (Matcher)Is.is((Object)"/host:/container:rw,Z"));
    }
}

