/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Ports;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BindingTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void parseIpAndPort() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1:80"), (Object)Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80));
    }

    @Test
    public void parsePortOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"80"), (Object)Ports.Binding.bindPort((int)80));
    }

    @Test
    public void parseIPOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1"), (Object)Ports.Binding.bindIp((String)"127.0.0.1"));
    }

    @Test
    public void parseEmptyString() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)""), (Object)Ports.Binding.empty());
    }

    @Test
    @Ignore
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Binding 'nonsense'");
        Ports.Binding.parse((String)"nonsense");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Binding 'null'");
        Ports.Binding.parse(null);
    }

    @Test
    public void toStringIpAndHost() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1:80").toString(), (Object)"127.0.0.1:80");
    }

    @Test
    public void toStringPortOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"80").toString(), (Object)"80");
    }

    @Test
    public void toStringIpOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1").toString(), (Object)"127.0.0.1");
    }
}

