/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerHostConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Test;

public class ContainerTest {
    @Test
    public void serderJson1() throws IOException {
        CollectionType type = JSONTestHelper.getMapper().getTypeFactory().constructCollectionType(List.class, Container.class);
        List containers = (List)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "containers/json/filter1.json", (JavaType)type);
        MatcherAssert.assertThat((Object)containers.size(), (Matcher)IsEqual.equalTo((Object)1));
        Container container = (Container)containers.get(0);
        MatcherAssert.assertThat((Object)container.getImageId(), (Matcher)IsEqual.equalTo((Object)"sha256:0cb40641836c461bc97c793971d84d758371ed682042457523e4ae701efe7ec9"));
        MatcherAssert.assertThat((Object)container.getSizeRootFs(), (Matcher)IsEqual.equalTo((Object)1113554L));
        ContainerHostConfig hostConfig = container.getHostConfig();
        MatcherAssert.assertThat((Object)hostConfig, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)hostConfig.getNetworkMode(), (Matcher)IsEqual.equalTo((Object)"default"));
    }
}

