/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.InternetProtocol;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExposedPortTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void parsePortAndProtocol() {
        ExposedPort exposedPort = ExposedPort.parse((String)"80/tcp");
        Assert.assertEquals((Object)exposedPort, (Object)new ExposedPort(80, InternetProtocol.TCP));
    }

    @Test
    public void parsePortOnly() {
        ExposedPort exposedPort = ExposedPort.parse((String)"80");
        Assert.assertEquals((Object)exposedPort, (Object)new ExposedPort(80, InternetProtocol.DEFAULT));
    }

    @Test
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing ExposedPort 'nonsense'");
        ExposedPort.parse((String)"nonsense");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing ExposedPort 'null'");
        ExposedPort.parse(null);
    }

    @Test
    public void stringify() {
        Assert.assertEquals((Object)ExposedPort.parse((String)"80/tcp").toString(), (Object)"80/tcp");
    }
}

