/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ExposedPortsTest {
    @Test
    public void usesToJson() throws Exception {
        ExposedPorts ports = new ExposedPorts(new ExposedPort[]{new ExposedPort(80), new ExposedPort(123, InternetProtocol.UDP), new ExposedPort(3868, InternetProtocol.SCTP)});
        String json = JSONTestHelper.getMapper().writeValueAsString((Object)ports);
        List<Map.Entry<String, JsonNode>> jsonEntries = this.getJsonEntries(json);
        String jsonExpected = "{\"80/tcp\":{},\"123/udp\":{},\"3868/sctp\":{}}";
        List<Map.Entry<String, JsonNode>> jsonEntriesExpected = this.getJsonEntries(jsonExpected);
        MatcherAssert.assertThat((Object)jsonEntries.toArray(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])jsonEntriesExpected.toArray()));
    }

    private List<Map.Entry<String, JsonNode>> getJsonEntries(String json) throws Exception {
        JsonNode jsonNode = (JsonNode)JSONTestHelper.getMapper().readValue(json, JsonNode.class);
        return Lists.newArrayList((Iterator)jsonNode.fields());
    }

    @Test
    public void usesFromJson() throws Exception {
        ExposedPorts ports = (ExposedPorts)JSONTestHelper.getMapper().readValue("{\"80/tcp\":{},\"123/udp\":{},\"3868/sctp\":{}}", ExposedPorts.class);
        MatcherAssert.assertThat((Object)ports, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ports.getExposedPorts(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new ExposedPort[]{new ExposedPort(80), new ExposedPort(123, InternetProtocol.UDP), new ExposedPort(3868, InternetProtocol.SCTP)}));
    }

    @Test
    public void usesFromJsonWithDuplicate() throws Exception {
        ExposedPorts ports = new ExposedPorts(new ExposedPort[]{new ExposedPort(80, InternetProtocol.UDP), new ExposedPort(80), new ExposedPort(80)});
        MatcherAssert.assertThat((Object)ports, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ports.getExposedPorts(), (Matcher)Matchers.arrayWithSize((int)3));
        Map map = ports.toPrimitive();
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.aMapWithSize((int)2));
    }
}

