/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Identifier;
import org.junit.Assert;
import org.junit.Test;

public class IdentifierTest {
    @Test
    public void testFromCompoundString() throws Exception {
        Identifier i1 = Identifier.fromCompoundString((String)"10.0.0.1/jim");
        Identifier i2 = Identifier.fromCompoundString((String)"10.0.0.1/jim:123");
        Identifier i3 = Identifier.fromCompoundString((String)"10.0.0.1:123/jim:124");
        Identifier i3A = Identifier.fromCompoundString((String)"10.0.0.1:123/jim:latest");
        Assert.assertTrue((!i1.tag.isPresent() ? 1 : 0) != 0);
        Assert.assertEquals((Object)i1.repository.name, (Object)"10.0.0.1/jim");
        Assert.assertTrue((boolean)i2.tag.isPresent());
        Assert.assertEquals(i2.tag.get(), (Object)"123");
        Assert.assertEquals((Object)i2.repository.name, (Object)"10.0.0.1/jim");
        Assert.assertTrue((boolean)i3.tag.isPresent());
        Assert.assertEquals(i3.tag.get(), (Object)"124");
        Assert.assertEquals((Object)i3.repository.name, (Object)"10.0.0.1:123/jim");
        Assert.assertEquals((long)i3.repository.getURL().getPort(), (long)123L);
        Assert.assertEquals(i3A.tag.get(), (Object)"latest");
        Identifier i4 = Identifier.fromCompoundString((String)"centos:latest");
        Assert.assertTrue((boolean)i4.tag.isPresent());
        Assert.assertEquals(i4.tag.get(), (Object)"latest");
        Identifier i5 = Identifier.fromCompoundString((String)"busybox");
        Assert.assertTrue((!i5.tag.isPresent() ? 1 : 0) != 0);
        Identifier i6 = Identifier.fromCompoundString((String)"10.0.0.1:5000/my-test-image:1234");
        Assert.assertEquals((Object)i6.repository.getPath(), (Object)"my-test-image");
    }
}

