/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.InternetProtocol;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InternetProtocolTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void defaultProtocol() {
        Assert.assertEquals((Object)InternetProtocol.DEFAULT, (Object)InternetProtocol.TCP);
    }

    @Test
    public void stringify() {
        Assert.assertEquals((Object)InternetProtocol.TCP.toString(), (Object)"tcp");
    }

    @Test
    public void parseUpperCase() {
        Assert.assertEquals((Object)InternetProtocol.parse((String)"TCP"), (Object)InternetProtocol.TCP);
    }

    @Test
    public void parseLowerCase() {
        Assert.assertEquals((Object)InternetProtocol.parse((String)"tcp"), (Object)InternetProtocol.TCP);
    }

    @Test
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Protocol 'xx'");
        InternetProtocol.parse((String)"xx");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Protocol 'null'");
        InternetProtocol.parse(null);
    }
}

