/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Link;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LinkTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void parse() {
        Link link = Link.parse((String)"name:alias");
        Assert.assertEquals((Object)link.getName(), (Object)"name");
        Assert.assertEquals((Object)link.getAlias(), (Object)"alias");
    }

    @Test
    public void parseWithContainerNames() {
        Link link = Link.parse((String)"/name:/conatiner/alias");
        Assert.assertEquals((Object)link.getName(), (Object)"name");
        Assert.assertEquals((Object)link.getAlias(), (Object)"alias");
    }

    @Test
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Link 'nonsense'");
        Link.parse((String)"nonsense");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing Link 'null'");
        Link.parse(null);
    }

    @Test
    public void stringify() {
        Assert.assertEquals((Object)Link.parse((String)"name:alias").toString(), (Object)"name:alias");
    }
}

