/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PortBindingTest {
    private static final ExposedPort TCP_8080 = ExposedPort.tcp((int)8080);
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void fullDefinition() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1:80:8080/tcp"), (Object)new PortBinding(Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80), TCP_8080));
    }

    @Test
    public void noProtocol() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1:80:8080"), (Object)new PortBinding(Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80), TCP_8080));
    }

    @Test
    public void noHostIp() {
        Assert.assertEquals((Object)PortBinding.parse((String)"80:8080/tcp"), (Object)new PortBinding(Ports.Binding.bindPort((int)80), TCP_8080));
    }

    @Test
    public void portsOnly() {
        Assert.assertEquals((Object)PortBinding.parse((String)"80:8080"), (Object)new PortBinding(Ports.Binding.bindPort((int)80), TCP_8080));
    }

    @Test
    public void exposedPortOnly() {
        Assert.assertEquals((Object)PortBinding.parse((String)"8080"), (Object)new PortBinding(Ports.Binding.empty(), TCP_8080));
    }

    @Test
    public void dynamicHostPort() {
        Assert.assertEquals((Object)PortBinding.parse((String)"127.0.0.1::8080"), (Object)new PortBinding(Ports.Binding.bindIp((String)"127.0.0.1"), TCP_8080));
    }

    @Test
    @Ignore
    public void parseInvalidInput() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing PortBinding 'nonsense'");
        PortBinding.parse((String)"nonsense");
    }

    @Test
    public void parseNull() {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing PortBinding 'null'");
        PortBinding.parse(null);
    }
}

