/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PortsSerializingTest {
    private final String jsonWithDoubleBindingForOnePort = "{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}";
    private final String jsonWithNullBindingForOnePort = "{\"80/tcp\":null}";

    @Test
    public void deserializingPortWithMultipleBindings() throws Exception {
        Ports ports = (Ports)JSONTestHelper.getMapper().readValue("{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}", Ports.class);
        Map map = ports.getBindings();
        Assert.assertEquals((long)map.size(), (long)1L);
        Ports.Binding[] bindings = (Ports.Binding[])map.get(ExposedPort.tcp((int)80));
        Assert.assertEquals((long)bindings.length, (long)2L);
        Assert.assertEquals((Object)bindings[0], (Object)new Ports.Binding("10.0.0.1", "80"));
        Assert.assertEquals((Object)bindings[1], (Object)new Ports.Binding("10.0.0.2", "80"));
    }

    @Test
    public void serializingPortWithMultipleBindings() throws Exception {
        Ports ports = new Ports();
        ports.bind(ExposedPort.tcp((int)80), new Ports.Binding("10.0.0.1", "80"));
        ports.bind(ExposedPort.tcp((int)80), new Ports.Binding("10.0.0.2", "80"));
        Assert.assertEquals((Object)JSONTestHelper.getMapper().writeValueAsString((Object)ports), (Object)"{\"80/tcp\":[{\"HostIp\":\"10.0.0.1\",\"HostPort\":\"80\"},{\"HostIp\":\"10.0.0.2\",\"HostPort\":\"80\"}]}");
    }

    @Test
    public void serializingEmptyBinding() throws Exception {
        Ports ports = new Ports(ExposedPort.tcp((int)80), new Ports.Binding(null, null));
        Assert.assertEquals((Object)JSONTestHelper.getMapper().writeValueAsString((Object)ports), (Object)"{\"80/tcp\":[{\"HostIp\":\"\",\"HostPort\":\"\"}]}");
    }

    @Test
    public void deserializingPortWithNullBindings() throws Exception {
        Ports ports = (Ports)JSONTestHelper.getMapper().readValue("{\"80/tcp\":null}", Ports.class);
        Map map = ports.getBindings();
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertNull(map.get(ExposedPort.tcp((int)80)));
    }

    @Test
    public void serializingWithNullBindings() throws Exception {
        Ports ports = new Ports();
        ports.bind(ExposedPort.tcp((int)80), null);
        Assert.assertEquals((Object)JSONTestHelper.getMapper().writeValueAsString((Object)ports), (Object)"{\"80/tcp\":null}");
    }
}

