/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.RestartPolicy;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RestartPolicyParsingTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void noRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"no"), (Object)RestartPolicy.noRestart());
    }

    @Test
    public void alwaysRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"always"), (Object)RestartPolicy.alwaysRestart());
    }

    @Test
    public void unlessStoppedRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"unless-stopped"), (Object)RestartPolicy.unlessStoppedRestart());
    }

    @Test
    public void onFailureRestart() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"on-failure"), (Object)RestartPolicy.onFailureRestart((int)0));
    }

    @Test
    public void onFailureRestartWithCount() throws Exception {
        Assert.assertEquals((Object)RestartPolicy.parse((String)"on-failure:2"), (Object)RestartPolicy.onFailureRestart((int)2));
    }

    @Test
    public void illegalSyntax() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing RestartPolicy 'nonsense'");
        RestartPolicy.parse((String)"nonsense");
    }

    @Test
    public void illegalRetryCount() throws Exception {
        this.expectedEx.expect(IllegalArgumentException.class);
        this.expectedEx.expectMessage("Error parsing RestartPolicy 'on-failure:X'");
        RestartPolicy.parse((String)"on-failure:X");
    }
}

