/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.model.BlkioStatEntry;
import com.github.dockerjava.api.model.BlkioStatsConfig;
import com.github.dockerjava.api.model.CpuStatsConfig;
import com.github.dockerjava.api.model.CpuUsageConfig;
import com.github.dockerjava.api.model.MemoryStatsConfig;
import com.github.dockerjava.api.model.PidsStatsConfig;
import com.github.dockerjava.api.model.StatisticNetworksConfig;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.api.model.StatsConfig;
import com.github.dockerjava.api.model.ThrottlingDataConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Test;

public class StatisticsTest {
    @Test
    public void serderJson1() throws IOException {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(Statistics.class);
        Statistics statistics = (Statistics)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_27, "containers/container/stats/stats1.json", type);
        MatcherAssert.assertThat((Object)statistics.getRead(), (Matcher)IsEqual.equalTo((Object)"2017-12-06T00:42:03.8352972Z"));
        StatisticNetworksConfig network = (StatisticNetworksConfig)statistics.getNetworks().get("eth0");
        MatcherAssert.assertThat((Object)network.getRxBytes(), (Matcher)CoreMatchers.is((Object)1230L));
        MatcherAssert.assertThat((Object)network.getRxPackets(), (Matcher)CoreMatchers.is((Object)19L));
        MatcherAssert.assertThat((Object)network.getRxErrors(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)network.getRxDropped(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)network.getTxBytes(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)network.getTxPackets(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)network.getTxErrors(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)network.getTxDropped(), (Matcher)CoreMatchers.is((Object)0L));
        MemoryStatsConfig memoryStats = statistics.getMemoryStats();
        MatcherAssert.assertThat((Object)memoryStats.getUsage(), (Matcher)CoreMatchers.is((Object)647168L));
        MatcherAssert.assertThat((Object)memoryStats.getMaxUsage(), (Matcher)CoreMatchers.is((Object)0x1A0000L));
        StatsConfig stats = memoryStats.getStats();
        MatcherAssert.assertThat((Object)stats.getActiveAnon(), (Matcher)CoreMatchers.is((Object)102400L));
        MatcherAssert.assertThat((Object)stats.getActiveFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getCache(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getDirty(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getHierarchicalMemoryLimit(), (Matcher)CoreMatchers.is((Object)0x7FFFFFFFFFFFF000L));
        MatcherAssert.assertThat((Object)stats.getHierarchicalMemswLimit(), (Matcher)CoreMatchers.is((Object)0x7FFFFFFFFFFFF000L));
        MatcherAssert.assertThat((Object)stats.getInactiveAnon(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getInactiveFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getMappedFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getPgfault(), (Matcher)CoreMatchers.is((Object)9656L));
        MatcherAssert.assertThat((Object)stats.getPgmajfault(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getPgpgin(), (Matcher)CoreMatchers.is((Object)3425L));
        MatcherAssert.assertThat((Object)stats.getPgpgout(), (Matcher)CoreMatchers.is((Object)3400L));
        MatcherAssert.assertThat((Object)stats.getRss(), (Matcher)CoreMatchers.is((Object)102400L));
        MatcherAssert.assertThat((Object)stats.getRssHuge(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getSwap(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalActiveAnon(), (Matcher)CoreMatchers.is((Object)102400L));
        MatcherAssert.assertThat((Object)stats.getTotalActiveFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalCache(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalDirty(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalInactiveAnon(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalInactiveFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalMappedFile(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalPgfault(), (Matcher)CoreMatchers.is((Object)9656L));
        MatcherAssert.assertThat((Object)stats.getTotalPgmajfault(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalPgpgin(), (Matcher)CoreMatchers.is((Object)3425L));
        MatcherAssert.assertThat((Object)stats.getTotalPgpgout(), (Matcher)CoreMatchers.is((Object)3400L));
        MatcherAssert.assertThat((Object)stats.getTotalRss(), (Matcher)CoreMatchers.is((Object)102400L));
        MatcherAssert.assertThat((Object)stats.getTotalRssHuge(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalSwap(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalUnevictable(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getTotalWriteback(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getUnevictable(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)stats.getWriteback(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)memoryStats.getLimit(), (Matcher)CoreMatchers.is((Object)2095874048L));
        MatcherAssert.assertThat((Object)memoryStats.getFailcnt(), (Matcher)CoreMatchers.is((Object)0L));
        BlkioStatsConfig blkioStats = statistics.getBlkioStats();
        MatcherAssert.assertThat((Object)blkioStats.getIoServiceBytesRecursive(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)blkioStats.getIoServiceBytesRecursive(), (Matcher)IsEqual.equalTo(Arrays.asList(new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Read").withValue(Long.valueOf(823296L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Write").withValue(Long.valueOf(122880L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Sync").withValue(Long.valueOf(835584L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Async").withValue(Long.valueOf(110592L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Total").withValue(Long.valueOf(946176L)))));
        MatcherAssert.assertThat((Object)blkioStats.getIoServicedRecursive(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)blkioStats.getIoServicedRecursive(), (Matcher)IsEqual.equalTo(Arrays.asList(new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Read").withValue(Long.valueOf(145L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Write").withValue(Long.valueOf(4L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Sync").withValue(Long.valueOf(148L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Async").withValue(Long.valueOf(1L)), new BlkioStatEntry().withMajor(Long.valueOf(259L)).withMinor(Long.valueOf(0L)).withOp("Total").withValue(Long.valueOf(149L)))));
        MatcherAssert.assertThat((Object)blkioStats.getIoQueueRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)blkioStats.getIoServiceTimeRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)blkioStats.getIoWaitTimeRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)blkioStats.getIoMergedRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)blkioStats.getIoTimeRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)blkioStats.getSectorsRecursive(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        CpuStatsConfig cpuStats = statistics.getCpuStats();
        CpuUsageConfig cpuUsage = cpuStats.getCpuUsage();
        MatcherAssert.assertThat((Object)cpuUsage.getTotalUsage(), (Matcher)CoreMatchers.is((Object)212198028L));
        MatcherAssert.assertThat((Object)cpuUsage.getPercpuUsage(), (Matcher)IsEqual.equalTo(Arrays.asList(71592953L, 42494761L, 59298344L, 38811970L)));
        MatcherAssert.assertThat((Object)cpuUsage.getUsageInKernelmode(), (Matcher)CoreMatchers.is((Object)170000000L));
        MatcherAssert.assertThat((Object)cpuUsage.getUsageInUsermode(), (Matcher)CoreMatchers.is((Object)20000000L));
        MatcherAssert.assertThat((Object)cpuStats.getSystemCpuUsage(), (Matcher)CoreMatchers.is((Object)545941980000000L));
        MatcherAssert.assertThat((Object)cpuStats.getOnlineCpus(), (Matcher)CoreMatchers.is((Object)4L));
        ThrottlingDataConfig throttlingData = cpuStats.getThrottlingData();
        MatcherAssert.assertThat((Object)throttlingData.getPeriods(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)throttlingData.getThrottledPeriods(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)throttlingData.getThrottledTime(), (Matcher)CoreMatchers.is((Object)0L));
        CpuStatsConfig preCpuStats = statistics.getPreCpuStats();
        CpuUsageConfig preCpuUsage = preCpuStats.getCpuUsage();
        MatcherAssert.assertThat((Object)preCpuUsage.getTotalUsage(), (Matcher)CoreMatchers.is((Object)211307214L));
        MatcherAssert.assertThat((Object)preCpuUsage.getPercpuUsage(), (Matcher)IsEqual.equalTo(Arrays.asList(71451389L, 42097782L, 59298344L, 38459699L)));
        MatcherAssert.assertThat((Object)preCpuUsage.getUsageInKernelmode(), (Matcher)CoreMatchers.is((Object)170000000L));
        MatcherAssert.assertThat((Object)preCpuUsage.getUsageInUsermode(), (Matcher)CoreMatchers.is((Object)20000000L));
        MatcherAssert.assertThat((Object)preCpuStats.getSystemCpuUsage(), (Matcher)CoreMatchers.is((Object)545937990000000L));
        MatcherAssert.assertThat((Object)preCpuStats.getOnlineCpus(), (Matcher)CoreMatchers.is((Object)4L));
        ThrottlingDataConfig preThrottlingData = preCpuStats.getThrottlingData();
        MatcherAssert.assertThat((Object)preThrottlingData.getPeriods(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)preThrottlingData.getThrottledPeriods(), (Matcher)CoreMatchers.is((Object)0L));
        MatcherAssert.assertThat((Object)preThrottlingData.getThrottledTime(), (Matcher)CoreMatchers.is((Object)0L));
        PidsStatsConfig pidsStats = statistics.getPidsStats();
        MatcherAssert.assertThat((Object)pidsStats.getCurrent(), (Matcher)CoreMatchers.is((Object)2L));
    }
}

