/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class UlimitsTest {
    @Test
    public void usesToJson() throws Exception {
        Ulimit[] ulimits = new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096), new Ulimit("core", 99999999998L, 99999999999L)};
        String json = JSONTestHelper.getMapper().writeValueAsString((Object)ulimits);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.is((Object)"[{\"Name\":\"nproc\",\"Soft\":709,\"Hard\":1026},{\"Name\":\"nofile\",\"Soft\":1024,\"Hard\":4096},{\"Name\":\"core\",\"Soft\":99999999998,\"Hard\":99999999999}]"));
    }

    @Test
    public void usesFromJson() throws Exception {
        Ulimit[] ulimits = (Ulimit[])JSONTestHelper.getMapper().readValue("[{\"Name\":\"nproc\",\"Soft\":709,\"Hard\":1026},{\"Name\":\"nofile\",\"Soft\":1024,\"Hard\":4096},{\"Name\":\"core\",\"Soft\":99999999998,\"Hard\":99999999999}]", Ulimit[].class);
        MatcherAssert.assertThat((Object)ulimits, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ulimits, (Matcher)Matchers.arrayContaining((Object[])new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096), new Ulimit("core", 99999999998L, 99999999999L)}));
    }
}

