/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.VersionComponent;
import com.github.dockerjava.api.model.VersionPlatform;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class VersionTest {
    @Test
    public void testSerDer1() throws Exception {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(Version.class);
        Version version = (Version)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/version/1.json", type);
        MatcherAssert.assertThat((Object)version, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)version.getVersion(), (Matcher)CoreMatchers.is((Object)"1.10.1"));
        MatcherAssert.assertThat((Object)version.getApiVersion(), (Matcher)CoreMatchers.is((Object)"1.22"));
        MatcherAssert.assertThat((Object)version.getGitCommit(), (Matcher)CoreMatchers.is((Object)"9e83765"));
        MatcherAssert.assertThat((Object)version.getGoVersion(), (Matcher)CoreMatchers.is((Object)"go1.5.3"));
        MatcherAssert.assertThat((Object)version.getOperatingSystem(), (Matcher)CoreMatchers.is((Object)"linux"));
        MatcherAssert.assertThat((Object)version.getArch(), (Matcher)CoreMatchers.is((Object)"amd64"));
        MatcherAssert.assertThat((Object)version.getKernelVersion(), (Matcher)CoreMatchers.is((Object)"4.1.17-boot2docker"));
        MatcherAssert.assertThat((Object)version.getBuildTime(), (Matcher)CoreMatchers.is((Object)"2016-02-11T20:39:58.688092588+00:00"));
    }

    @Test
    public void version_1_38() throws Exception {
        JavaType type = JSONTestHelper.getMapper().getTypeFactory().constructType(Version.class);
        Version version = (Version)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_38, "/version/lcow.json", type);
        MatcherAssert.assertThat((Object)version, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)version.getApiVersion(), (Matcher)CoreMatchers.is((Object)"1.38"));
        MatcherAssert.assertThat((Object)version.getArch(), (Matcher)CoreMatchers.is((Object)"amd64"));
        MatcherAssert.assertThat((Object)version.getBuildTime(), (Matcher)CoreMatchers.is((Object)"2018-08-21T17:36:40.000000000+00:00"));
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("ApiVersion", "1.38");
        details.put("Arch", "amd64");
        details.put("BuildTime", "2018-08-21T17:36:40.000000000+00:00");
        details.put("Experimental", "true");
        details.put("GitCommit", "e68fc7a");
        details.put("GoVersion", "go1.10.3");
        details.put("KernelVersion", "10.0 17134 (17134.1.amd64fre.rs4_release.180410-1804)");
        details.put("MinAPIVersion", "1.24");
        details.put("Os", "windows");
        List<VersionComponent> components = Collections.singletonList(new VersionComponent().withDetails(details).withName("Engine").withVersion("18.06.1-ce"));
        MatcherAssert.assertThat((Object)version.getComponents(), (Matcher)Matchers.equalTo(components));
        MatcherAssert.assertThat((Object)version.getExperimental(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)version.getGitCommit(), (Matcher)CoreMatchers.is((Object)"e68fc7a"));
        MatcherAssert.assertThat((Object)version.getGoVersion(), (Matcher)CoreMatchers.is((Object)"go1.10.3"));
        MatcherAssert.assertThat((Object)version.getKernelVersion(), (Matcher)CoreMatchers.is((Object)"10.0 17134 (17134.1.amd64fre.rs4_release.180410-1804)"));
        MatcherAssert.assertThat((Object)version.getMinAPIVersion(), (Matcher)CoreMatchers.is((Object)"1.24"));
        MatcherAssert.assertThat((Object)version.getOperatingSystem(), (Matcher)CoreMatchers.is((Object)"windows"));
        MatcherAssert.assertThat((Object)version.getPlatform(), (Matcher)Matchers.equalTo((Object)new VersionPlatform().withName("")));
        MatcherAssert.assertThat((Object)version.getVersion(), (Matcher)CoreMatchers.is((Object)"18.06.1-ce"));
    }
}

