/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.api.model.VolumeBinds;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class VolumeBindsTest {
    @Test
    public void usesToJson() throws Exception {
        VolumeBinds binds = new VolumeBinds(new VolumeBind[]{new VolumeBind("/bar", "/foo"), new VolumeBind("/bop", "/bip")});
        String json = JSONTestHelper.getMapper().writeValueAsString((Object)binds);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.is((Object)"{\"/foo\":\"/bar\",\"/bip\":\"/bop\"}"));
    }

    @Test
    public void t() throws IOException {
        String s = "{\"/data\":\"/some/path\"}";
        VolumeBinds volumeBinds = (VolumeBinds)JSONTestHelper.getMapper().readValue(s, VolumeBinds.class);
        VolumeBind[] binds = volumeBinds.getBinds();
        Assert.assertEquals((long)binds.length, (long)1L);
        Assert.assertEquals((Object)binds[0].getHostPath(), (Object)"/some/path");
        Assert.assertEquals((Object)binds[0].getContainerPath(), (Object)"/data");
    }

    @Test(expected=JsonMappingException.class)
    public void t1() throws IOException {
        String s = "{\"/data\": {} }";
        JSONTestHelper.getMapper().readValue(s, VolumeBinds.class);
    }
}

