/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.cmd.CmdIT;
import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachContainerCmdIT
extends CmdIT {
    private static final Logger LOG = LoggerFactory.getLogger(AttachContainerCmdIT.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void attachContainerWithStdin() throws Exception {
        DockerClient dockerClient = this.dockerRule.getClient();
        String snippet = "hello world";
        CreateContainerResponse container = dockerClient.createContainerCmd("busybox").withCmd(new String[]{"/bin/sh", "-c", "read line && echo $line"}).withTty(Boolean.valueOf(false)).withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withStdinOpen(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                Assert.assertEquals((Object)frame.getStreamType(), (Object)StreamType.STDOUT);
                super.onNext(frame);
            }
        };
        try (PipedOutputStream out = new PipedOutputStream();
             PipedInputStream in = new PipedInputStream(out);){
            dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withStdIn((InputStream)in).exec((ResultCallback)callback);
            Assert.assertTrue((String)"Processing of the response should start shortly after executing `attachContainerCmd`", (boolean)callback.awaitStarted(5L, TimeUnit.SECONDS));
            dockerClient.startContainerCmd(container.getId()).exec();
            out.write((snippet + "\n").getBytes());
            out.flush();
            callback.awaitCompletion(15L, TimeUnit.SECONDS);
            callback.close();
        }
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }

    @Test
    public void attachContainerWithoutTTY() throws Exception {
        DockerClient dockerClient = this.dockerRule.getClient();
        String snippet = "hello world";
        CreateContainerResponse container = dockerClient.createContainerCmd("busybox:latest").withCmd(new String[]{"echo", snippet}).withTty(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                MatcherAssert.assertThat((Object)frame.getStreamType(), (Matcher)Matchers.equalTo((Object)StreamType.STDOUT));
                super.onNext(frame);
            }
        };
        dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withLogs(Boolean.valueOf(true)).exec((ResultCallback)callback);
        Assert.assertTrue((String)"Processing of the response should start shortly after executing `attachContainerCmd`", (boolean)callback.awaitStarted(5L, TimeUnit.SECONDS));
        dockerClient.startContainerCmd(container.getId()).exec();
        callback.awaitCompletion(30L, TimeUnit.SECONDS);
        callback.close();
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)snippet));
    }

    @Test
    public void attachContainerWithTTY() throws Exception {
        DockerClient dockerClient = this.dockerRule.getClient();
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("attachContainerTestDockerfile").getFile());
        String imageId = this.dockerRule.buildImage(baseDir);
        CreateContainerResponse container = dockerClient.createContainerCmd(imageId).withTty(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        AttachContainerTestCallback callback = new AttachContainerTestCallback(){

            @Override
            public void onNext(Frame frame) {
                MatcherAssert.assertThat((Object)frame.getStreamType(), (Matcher)Matchers.equalTo((Object)StreamType.RAW));
                super.onNext(frame);
            }
        };
        dockerClient.attachContainerCmd(container.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)callback);
        Assert.assertTrue((String)"Processing of the response should start shortly after executing `attachContainerCmd`", (boolean)callback.awaitStarted(5L, TimeUnit.SECONDS));
        dockerClient.startContainerCmd(container.getId()).exec();
        callback.awaitCompletion(15L, TimeUnit.SECONDS);
        callback.close();
        LOG.debug("log: {}", (Object)callback.toString());
        MatcherAssert.assertThat((Object)callback.toString(), (Matcher)Matchers.containsString((String)"stdout\r\nstderr"));
    }

    @Test
    public void attachContainerClosesStdoutWhenContainerExits() throws Exception {
        DockerClient dockerClient = this.dockerRule.getClient();
        CreateContainerResponse container = dockerClient.createContainerCmd("busybox:latest").withCmd(new String[]{"echo", "hello"}).withTty(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        final CountDownLatch gotLine = new CountDownLatch(1);
        try (ResultCallback.Adapter resultCallback = (ResultCallback.Adapter)dockerClient.attachContainerCmd(container.getId()).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

            public void onNext(Frame item) {
                LOG.info("Got frame: {}", (Object)item);
                if (item.getStreamType() == StreamType.STDOUT) {
                    gotLine.countDown();
                }
                super.onNext((Object)item);
            }

            public void onComplete() {
                LOG.info("On complete");
                super.onComplete();
            }
        });){
            resultCallback.awaitStarted(5L, TimeUnit.SECONDS);
            LOG.info("Attach started");
            dockerClient.startContainerCmd(container.getId()).exec();
            LOG.info("Container started");
            Assert.assertTrue((String)"Should get first line quickly after the start", (boolean)gotLine.await(15L, TimeUnit.SECONDS));
            resultCallback.awaitCompletion(5L, TimeUnit.SECONDS);
        }
    }

    public static class AttachContainerTestCallback
    extends ResultCallback.Adapter<Frame> {
        private final StringBuffer log = new StringBuffer();

        public void onNext(Frame item) {
            this.log.append(new String(item.getPayload()));
            super.onNext((Object)item);
        }

        public String toString() {
            return this.log.toString();
        }
    }
}

