/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.junit.DockerMatchers;
import com.github.dockerjava.junit.PrivateRegistryRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BuildImageCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(BuildImageCmd.class);
    @ClassRule
    public static PrivateRegistryRule REGISTRY = new PrivateRegistryRule();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder(new File("target/"));

    @Test
    public void author() throws Exception {
        String imageId = this.dockerRule.buildImage(this.fileFromBuildTestResource("AUTHOR"));
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse.getAuthor(), (Matcher)Matchers.equalTo((Object)"Guillaume J. Charmes \"guillaume@dotcloud.com\""));
    }

    @Test
    public void buildImageFromTar() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/file");
        Collection files = FileUtils.listFiles((File)baseDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        File tarFile = CompressArchiveUtil.archiveTARFiles((File)baseDir, (Iterable)files, (String)UUID.randomUUID().toString());
        String response = this.dockerfileBuild(new FileInputStream(tarFile));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void buildImageFromTarWithDockerfileNotInBaseDirectory() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerfileNotInBaseDirectory");
        Collection files = FileUtils.listFiles((File)baseDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        File tarFile = CompressArchiveUtil.archiveTARFiles((File)baseDir, (Iterable)files, (String)UUID.randomUUID().toString());
        String response = this.dockerfileBuild(new FileInputStream(tarFile), "dockerfileFolder/Dockerfile");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void onBuild() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ONBUILD/parent");
        this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withTag("docker-java-onbuild").start().awaitImageId();
        baseDir = this.fileFromBuildTestResource("ONBUILD/child");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void addUrl() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/url");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Example Domain"));
    }

    @Test
    public void addFileInSubfolder() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/fileInSubfolder");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void addFilesViaWildcard() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/filesViaWildcard");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testinclude1.sh"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Successfully executed testinclude2.sh")));
    }

    @Test
    public void addFolder() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/folder");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testAddFolder.sh"));
    }

    private String dockerfileBuild(InputStream tarInputStream, String dockerFilePath) throws Exception {
        return this.execBuild(this.dockerRule.getClient().buildImageCmd().withTarInputStream(tarInputStream).withDockerfilePath(dockerFilePath));
    }

    private String dockerfileBuild(InputStream tarInputStream) throws Exception {
        return this.execBuild(this.dockerRule.getClient().buildImageCmd().withTarInputStream(tarInputStream));
    }

    private String dockerfileBuild(File baseDir) throws Exception {
        return this.execBuild(this.dockerRule.getClient().buildImageCmd(baseDir));
    }

    private String execBuild(BuildImageCmd buildImageCmd) throws Exception {
        String imageId = buildImageCmd.withNoCache(Boolean.valueOf(true)).start().awaitImageId();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd(imageId).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        return this.dockerRule.containerLog(container.getId());
    }

    @Test(expected=DockerClientException.class)
    public void dockerignoreDockerfileIgnored() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/DockerfileIgnored");
        this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
    }

    @Test
    public void dockerignoreDockerfileNotIgnored() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/DockerfileNotIgnored");
        this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
    }

    @Test(expected=DockerClientException.class)
    public void dockerignoreInvalidDockerIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/InvalidDockerignorePattern");
        this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
    }

    @Test
    public void dockerignoreValidDockerIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/ValidDockerignorePattern");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/tmp/a/a /tmp/a/c /tmp/a/d"));
    }

    @Test
    public void env() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ENV");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"testENVSubstitution successfully completed"));
    }

    @Test
    public void fromPrivateRegistry() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        String imgName = authConfig.getRegistryAddress() + "/testuser/busybox";
        File dockerfile = this.folder.newFile("Dockerfile");
        FileUtils.writeStringToFile((File)dockerfile, (String)("FROM " + imgName));
        this.dockerRule.getClient().authCmd().withAuthConfig(authConfig).exec();
        this.dockerRule.getClient().tagImageCmd("busybox:latest", imgName, "latest").withForce().exec();
        this.dockerRule.getClient().pushImageCmd(imgName).withTag("latest").withAuthConfig(authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
        this.dockerRule.getClient().removeImageCmd(imgName).withForce(Boolean.valueOf(true)).exec();
        File baseDir = this.folder.getRoot();
        AuthConfigurations authConfigurations = new AuthConfigurations();
        authConfigurations.addConfig(authConfig);
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withBuildAuthConfigs(authConfigurations).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
    }

    @Test
    public void buildArgs() throws Exception {
        File baseDir = this.fileFromBuildTestResource("buildArgs");
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withBuildArg("testArg", "abc !@#$%^&*()_+").start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat(inspectImageResponse.getConfig().getLabels().get("test"), (Matcher)Matchers.equalTo((Object)"abc !@#$%^&*()_+"));
    }

    @Test
    public void labels() throws Exception {
        Assume.assumeThat((String)"API version should be >= 1.23", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_23));
        File baseDir = this.fileFromBuildTestResource("labels");
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withLabels(Collections.singletonMap("test", "abc")).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat(inspectImageResponse.getConfig().getLabels().get("test"), (Matcher)Matchers.equalTo((Object)"abc"));
    }

    @Test
    public void multipleTags() throws Exception {
        Assume.assumeThat((String)"API version should be >= 1.23", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_21));
        File baseDir = this.fileFromBuildTestResource("labels");
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withTag("fallback-when-withTags-not-called").withTags(new HashSet<String>(Arrays.asList("docker-java-test:tag1", "docker-java-test:tag2"))).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse.getRepoTags().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)inspectImageResponse.getRepoTags(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"docker-java-test:tag1", "docker-java-test:tag2"}));
    }

    @Test
    public void cacheFrom() throws Exception {
        Assume.assumeThat((Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_27));
        File baseDir1 = this.fileFromBuildTestResource("CacheFrom/test1");
        String imageId1 = this.dockerRule.getClient().buildImageCmd(baseDir1).start().awaitImageId();
        InspectImageResponse inspectImageResponse1 = this.dockerRule.getClient().inspectImageCmd(imageId1).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        File baseDir2 = this.fileFromBuildTestResource("CacheFrom/test2");
        String imageId2 = this.dockerRule.getClient().buildImageCmd(baseDir2).withCacheFrom(new HashSet<String>(Arrays.asList(imageId1))).start().awaitImageId();
        InspectImageResponse inspectImageResponse2 = this.dockerRule.getClient().inspectImageCmd(imageId2).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse2, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)inspectImageResponse2.getParent(), (Matcher)Matchers.equalTo((Object)inspectImageResponse1.getId()));
    }

    @Test
    public void quiet() {
        File baseDir = this.fileFromBuildTestResource("labels");
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withQuiet(Boolean.valueOf(true)).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)inspectImageResponse.getId(), (Matcher)Matchers.endsWith((String)imageId));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
    }

    @Test
    public void extraHosts() {
        Assume.assumeThat((Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_28));
        File baseDir = this.fileFromBuildTestResource("labels");
        String imageId = this.dockerRule.getClient().buildImageCmd(baseDir).withExtraHosts(new HashSet<String>(Arrays.asList("host1"))).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
    }

    public void dockerfileNotInBaseDirectory() throws Exception {
        File baseDirectory = this.fileFromBuildTestResource("dockerfileNotInBaseDirectory");
        File dockerfile = this.fileFromBuildTestResource("dockerfileNotInBaseDirectory/dockerfileFolder/Dockerfile");
        BuildImageCmd command = this.dockerRule.getClient().buildImageCmd().withBaseDirectory(baseDirectory).withDockerfile(dockerfile);
        String response = this.execBuild(command);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    private File fileFromBuildTestResource(String resource) {
        return new File(Thread.currentThread().getContextClassLoader().getResource("buildTests/" + resource).getFile());
    }
}

