/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class CommitCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CommitCmdIT.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void commit() throws DockerException, InterruptedException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LOG.info("Committing container: {}", (Object)container.toString());
        String imageId = this.dockerRule.getClient().commitCmd(container.getId()).exec();
        CommitCmdIT commitCmdIT = this;
        synchronized (commitCmdIT) {
            this.wait(5000L);
        }
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)HasFieldWithValue.hasField((String)"container", (Matcher)Matchers.startsWith((String)container.getId())));
        MatcherAssert.assertThat((Object)inspectImageResponse.getContainerConfig().getImage(), (Matcher)Matchers.equalTo((Object)"busybox:latest"));
        InspectImageResponse busyboxImg = this.dockerRule.getClient().inspectImageCmd("busybox").exec();
        MatcherAssert.assertThat((Object)inspectImageResponse.getParent(), (Matcher)Matchers.equalTo((Object)busyboxImg.getId()));
    }

    @Test
    public void commitWithLabels() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        Integer status = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)status, (Matcher)Matchers.is((Object)0));
        LOG.info("Committing container: {}", (Object)container.toString());
        ImmutableMap labels = ImmutableMap.of((Object)"label1", (Object)"abc", (Object)"label2", (Object)"123");
        String imageId = this.dockerRule.getClient().commitCmd(container.getId()).withLabels((Map)labels).exec();
        InspectImageResponse inspectImageResponse = this.dockerRule.getClient().inspectImageCmd(imageId).exec();
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        Map responseLabels = inspectImageResponse.getConfig().getLabels();
        MatcherAssert.assertThat((Object)responseLabels.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat(responseLabels.get("label1"), (Matcher)Matchers.equalTo((Object)"abc"));
        MatcherAssert.assertThat(responseLabels.get("label2"), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test(expected=NotFoundException.class)
    public void commitNonExistingContainer() throws DockerException {
        this.dockerRule.getClient().commitCmd("non-existent").exec();
    }
}

