/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.junit.DockerAssume;
import net.jcip.annotations.ThreadSafe;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

@ThreadSafe
public class ConnectToNetworkCmdIT
extends CmdIT {
    @Test
    public void connectToNetwork() throws InterruptedException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        String networkName = "connectToNetwork";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).exec();
        this.dockerRule.getClient().connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        Network updatedNetwork = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Assert.assertTrue((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        Assert.assertNotNull(inspectContainerResponse.getNetworkSettings().getNetworks().get(networkName));
    }

    @Test
    public void connectToNetworkWithContainerNetwork() throws InterruptedException {
        DockerAssume.assumeNotSwarm("no network in swarm", this.dockerRule);
        String subnetPrefix = "10.100.100";
        String networkName = "ContainerWithNetwork";
        String containerIp = "10.100.100.100";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        try {
            this.dockerRule.getClient().removeNetworkCmd("ContainerWithNetwork").exec();
        }
        catch (DockerException dockerException) {
            // empty catch block
        }
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName("ContainerWithNetwork").withIpam(new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.100.100.0/24")})).exec();
        this.dockerRule.getClient().connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).withContainerNetwork(new ContainerNetwork().withAliases(new String[]{"aliasName"}).withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address("10.100.100.100"))).exec();
        Network updatedNetwork = this.dockerRule.getClient().inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Network.ContainerNetworkConfig containerNetworkConfig = (Network.ContainerNetworkConfig)updatedNetwork.getContainers().get(container.getId());
        Assert.assertNotNull((Object)containerNetworkConfig);
        MatcherAssert.assertThat((Object)containerNetworkConfig.getIpv4Address(), (Matcher)Is.is((Object)"10.100.100.100/24"));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        ContainerNetwork testNetwork = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get("ContainerWithNetwork");
        Assert.assertNotNull((Object)testNetwork);
        MatcherAssert.assertThat((Object)testNetwork.getAliases(), (Matcher)Matchers.hasItem((Object)"aliasName"));
        MatcherAssert.assertThat((Object)testNetwork.getGateway(), (Matcher)Is.is((Object)"10.100.100.1"));
        MatcherAssert.assertThat((Object)testNetwork.getIpAddress(), (Matcher)Is.is((Object)"10.100.100.100"));
    }
}

