/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import ch.lambdaj.Lambda;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ChangeLog;
import com.github.dockerjava.cmd.CmdIT;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;

public class ContainerDiffCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(ContainerDiffCmdIT.class);

    @Test
    public void testContainerDiff() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"touch", "/test"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        List filesystemDiff = this.dockerRule.getClient().containerDiffCmd(container.getId()).exec();
        LOG.info("Container DIFF: {}", (Object)filesystemDiff.toString());
        MatcherAssert.assertThat((Object)filesystemDiff.size(), (Matcher)Matchers.equalTo((Object)1));
        ChangeLog testChangeLog = (ChangeLog)Lambda.selectUnique((Object)filesystemDiff, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"path", (Matcher)Matchers.equalTo((Object)"/test")));
        MatcherAssert.assertThat((Object)testChangeLog, (Matcher)HasFieldWithValue.hasField((String)"kind", (Matcher)Matchers.equalTo((Object)1)));
    }

    @Test(expected=NotFoundException.class)
    public void testContainerDiffWithNonExistingContainer() throws DockerException {
        this.dockerRule.getClient().containerDiffCmd("non-existing").exec();
    }
}

