/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.utils.TestUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyArchiveFromContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CopyArchiveFromContainerCmdIT.class);

    @Test
    public void copyFromContainer() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName("copyFromContainer").withCmd(new String[]{"touch", "/copyFromContainer"}).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InputStream response = this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "/copyFromContainer").exec();
        String responseAsString = TestUtils.asString(response);
        Assert.assertNotNull((Object)responseAsString);
        Assert.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=NotFoundException.class)
    public void copyFromNonExistingContainer() throws Exception {
        this.dockerRule.getClient().copyArchiveFromContainerCmd("non-existing", "/test").exec();
    }

    @Test
    public void copyFromContainerBinaryFile() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName("copyFromContainerBinaryFile").exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        Path temp = Files.createTempFile("", ".tar.gz", new FileAttribute[0]);
        Path binaryFile = Paths.get("src/test/resources/testCopyFromArchive/binary.dat", new String[0]);
        CompressArchiveUtil.tar((Path)binaryFile, (Path)temp, (boolean)true, (boolean)false);
        try (InputStream uploadStream = Files.newInputStream(temp, new OpenOption[0]);){
            this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withTarInputStream(uploadStream).exec();
        }
        InputStream response = this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "/binary.dat").exec();
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(response);){
            TarArchiveEntry nextTarEntry = tarInputStream.getNextTarEntry();
            Assert.assertEquals((Object)nextTarEntry.getName(), (Object)"binary.dat");
            try (InputStream binaryFileInputStream = Files.newInputStream(binaryFile, StandardOpenOption.READ);){
                Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)binaryFileInputStream, (InputStream)tarInputStream));
            }
            Assert.assertNull((String)"Nothing except binary.dat is expected to be copied.", (Object)tarInputStream.getNextTarEntry());
        }
    }
}

