/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyArchiveToContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CopyArchiveToContainerCmdIT.class);

    @Test
    public void copyFileToContainer() throws Exception {
        CreateContainerResponse container = this.prepareContainerForCopy("1");
        Path temp = Files.createTempFile("", ".tar.gz", new FileAttribute[0]);
        CompressArchiveUtil.tar((Path)Paths.get("src/test/resources/testReadFile", new String[0]), (Path)temp, (boolean)true, (boolean)false);
        try (InputStream uploadStream = Files.newInputStream(temp, new OpenOption[0]);){
            this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withTarInputStream(uploadStream).exec();
            this.assertFileCopied(container);
        }
    }

    @Test
    public void copyStreamToContainer() throws Exception {
        CreateContainerResponse container = this.prepareContainerForCopy("2");
        this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withHostResource("src/test/resources/testReadFile").exec();
        this.assertFileCopied(container);
    }

    @Test
    public void copyStreamToContainerTwice() throws Exception {
        CreateContainerResponse container = this.prepareContainerForCopy("rerun");
        CopyArchiveToContainerCmd copyArchiveToContainerCmd = this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withHostResource("src/test/resources/testReadFile");
        copyArchiveToContainerCmd.exec();
        this.assertFileCopied(container);
        copyArchiveToContainerCmd.exec();
    }

    private CreateContainerResponse prepareContainerForCopy(String method) {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withName("docker-java-itest-copyToContainer" + method).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        return container;
    }

    private void assertFileCopied(CreateContainerResponse container) throws IOException {
        try (InputStream response = this.dockerRule.getClient().copyArchiveFromContainerCmd(container.getId(), "testReadFile").exec();){
            boolean bytesAvailable = response.read() != -1;
            Assert.assertTrue((String)"The file was not copied to the container.", (boolean)bytesAvailable);
        }
    }

    @Test(expected=NotFoundException.class)
    public void copyToNonExistingContainer() throws Exception {
        this.dockerRule.getClient().copyArchiveToContainerCmd("non-existing").withHostResource("src/test/resources/testReadFile").exec();
    }

    @Test
    public void copyDirWithLastAddedTarEntryEmptyDir() throws Exception {
        Path localDir = Files.createTempDirectory(null, new FileAttribute[0]);
        localDir.toFile().deleteOnExit();
        Files.createDirectory(localDir.resolve("b"), new FileAttribute[0]);
        Path dirWithFile = Files.createDirectory(localDir.resolve("a"), new FileAttribute[0]);
        Files.createFile(dirWithFile.resolve("file"), new FileAttribute[0]);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withHostResource(localDir.toString()).exec();
        FileUtils.deleteDirectory((File)localDir.toFile());
    }

    @Test
    public void copyFileWithExecutePermission() throws Exception {
        Path scriptPath = Files.createTempFile("run", ".sh", new FileAttribute[0]);
        boolean executable = scriptPath.toFile().setExecutable(true, false);
        if (!executable) {
            throw new Exception("Execute permission on file not set!");
        }
        String snippet = "Running script with execute permission.";
        String scriptTextStr = "#!/bin/sh\necho \"" + snippet + "\"";
        Files.write(scriptPath, scriptTextStr.getBytes(), new OpenOption[0]);
        String containerCmd = "sleep 3; /home/" + scriptPath.getFileName().toString();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withName("copyFileWithExecutivePerm").withCmd(new String[]{"/bin/sh", "-c", containerCmd}).exec();
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        this.dockerRule.getClient().copyArchiveToContainerCmd(container.getId()).withRemotePath("/home").withHostResource(scriptPath.toString()).exec();
        int exitCode = this.dockerRule.getClient().waitContainerCmd(container.getId()).start().awaitStatusCode();
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
    }
}

