/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.junit.DockerMatchers;
import com.github.dockerjava.utils.TestUtils;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFileFromContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CopyFileFromContainerCmdIT.class);

    @Test
    public void copyFromContainer() throws Exception {
        Assume.assumeThat((String)"Doesn't work since 1.24", (Object)((Object)this.dockerRule), (Matcher)Matchers.not(DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_24)));
        DockerAssume.assumeNotSwarm("", this.dockerRule);
        String containerName = "copyFileFromContainer";
        this.dockerRule.ensureContainerRemoved(containerName);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withName(containerName).withCmd(new String[]{"touch", "/copyFileFromContainer"}).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InputStream response = this.dockerRule.getClient().copyFileFromContainerCmd(container.getId(), "/copyFileFromContainer").exec();
        String responseAsString = TestUtils.asString(response);
        Assert.assertNotNull((Object)responseAsString);
        Assert.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=NotFoundException.class)
    public void copyFromNonExistingContainer() throws Exception {
        this.dockerRule.getClient().copyFileFromContainerCmd("non-existing", "/test").exec();
    }
}

