/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.DockerObjectAccessor;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.junit.DockerMatchers;
import com.github.dockerjava.junit.PrivateRegistryRule;
import com.github.dockerjava.utils.TestUtils;
import java.io.File;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CreateContainerCmdIT
extends CmdIT {
    public static final Logger LOG = LoggerFactory.getLogger(CreateContainerCmdIT.class);
    @ClassRule
    public static PrivateRegistryRule REGISTRY = new PrivateRegistryRule();
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder(new File("target/"));
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test(expected=ConflictException.class)
    public void createContainerWithExistingName() throws DockerException {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"env"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"env"}).withName(containerName).exec();
    }

    @Test
    public void createContainerWithVolume() throws DockerException {
        Volume volume = new Volume("/var/log");
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withVolumes(new Volume[]{volume}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Inspect container {}", (Object)inspectContainerResponse.getConfig().getVolumes());
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/var/log"}));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getDestination(), (Matcher)Matchers.equalTo((Object)volume));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getMode(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getRW(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void createContainerWithReadOnlyVolume() throws DockerException {
        Volume volume = new Volume("/srv/test");
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withVolumes(new Volume[]{volume}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Inspect container {}", (Object)inspectContainerResponse.getConfig().getVolumes());
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/srv/test"}));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getDestination(), (Matcher)Matchers.equalTo((Object)volume));
    }

    @Test
    public void createContainerWithVolumesFrom() throws DockerException {
        String container1Name = UUID.randomUUID().toString();
        CreateVolumeResponse volume1Info = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().exec();
        CreateVolumeResponse volume2Info = (CreateVolumeResponse)this.dockerRule.getClient().createVolumeCmd().exec();
        Volume volume1 = new Volume("/src/webapp1");
        Volume volume2 = new Volume("/src/webapp2");
        Bind bind1 = new Bind(volume1Info.getName(), volume1);
        Bind bind2 = new Bind(volume2Info.getName(), volume2);
        CreateContainerResponse container1 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withName(container1Name).withHostConfig(HostConfig.newHostConfig().withBinds(new Bind[]{bind1, bind2})).exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        InspectContainerResponse inspectContainerResponse1 = this.dockerRule.getClient().inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse1.getHostConfig().getBinds()), (Matcher)Matchers.containsInAnyOrder((Object[])new Bind[]{bind1, bind2}));
        MatcherAssert.assertThat((Object)inspectContainerResponse1, (Matcher)DockerMatchers.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
        CreateContainerResponse container2 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(HostConfig.newHostConfig().withVolumesFrom(new VolumesFrom[]{new VolumesFrom(container1Name)})).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getVolumesFrom(), (Matcher)Matchers.hasItemInArray((Object)new VolumesFrom(container1Name)));
        MatcherAssert.assertThat((Object)inspectContainerResponse1, (Matcher)DockerMatchers.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
        this.dockerRule.getClient().startContainerCmd(container2.getId()).exec();
        LOG.info("Started container2 {}", (Object)container2.toString());
        inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getVolumesFrom(), (Matcher)Matchers.hasItemInArray((Object)new VolumesFrom(container1Name)));
        MatcherAssert.assertThat((Object)inspectContainerResponse2, (Matcher)DockerMatchers.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
    }

    @Test
    public void createContainerWithEnv() throws Exception {
        String testVariable = "VARIABLE=success";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withEnv(new String[]{"VARIABLE=success"}).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)"VARIABLE=success"));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"VARIABLE=success"));
    }

    @Test
    public void createContainerWithEnvAdditive() throws Exception {
        String testVariable1 = "VARIABLE1=success1";
        String testVariable2 = "VARIABLE2=success2";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withEnv(new String[]{"VARIABLE1=success1"}).withEnv(new String[]{"VARIABLE2=success2"}).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"VARIABLE1=success1")));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)"VARIABLE2=success2"));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"VARIABLE1=success1")));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"VARIABLE2=success2"));
    }

    @Test
    public void createContainerWithEnvAdditiveMap() throws Exception {
        String[] testVariables1 = new String[]{"VARIABLE1=success1", "VARIABLE2=success2"};
        String[] testVariables2 = new String[]{"VARIABLE3=success3", "VARIABLE4=success4"};
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withEnv(testVariables1).withEnv(testVariables2).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)testVariables1[0])));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)testVariables1[1])));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)testVariables2[0]));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)testVariables2[1]));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)testVariables1[0])));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)testVariables1[1])));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)testVariables2[0]));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)testVariables2[1]));
    }

    @Test
    public void createContainerWithEnvAsVararg() throws Exception {
        String testVariable1 = "VARIABLE1=success1";
        String testVariable2 = "VARIABLE2=success2";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withEnv(new String[]{"VARIABLE1=success1", "VARIABLE2=success2"}).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)"VARIABLE1=success1"));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)"VARIABLE2=success2"));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"VARIABLE1=success1"));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"VARIABLE2=success2"));
    }

    @Test
    public void createContainerWithEnvAsMap() throws Exception {
        String[] testVariables = new String[]{"VARIABLE1=success1", "VARIABLE2=success2"};
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withEnv(testVariables).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)testVariables[0]));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)testVariables[1]));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)testVariables[0]));
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)testVariables[1]));
    }

    @Test
    public void createContainerWithHostname() throws Exception {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostName("docker-java").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getHostName(), (Matcher)Matchers.equalTo((Object)"docker-java"));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.dockerRule.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"HOSTNAME=docker-java"));
    }

    @Test(expected=ConflictException.class)
    public void createContainerWithName() throws DockerException {
        String containerName = "container_";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName(containerName).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getName(), (Matcher)Matchers.equalTo((Object)("/" + containerName)));
        this.dockerRule.getClient().createContainerCmd("busybox:latest").withName(containerName).withCmd(new String[]{"env"}).exec();
    }

    @Test
    public void createContainerWithLink() throws DockerException {
        String containerName1 = "containerWithlink_";
        String containerName2 = "container2Withlink_";
        CreateContainerResponse container1 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withName(containerName1).exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerRule.getClient().inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        CreateContainerResponse container2 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName(containerName2).withCmd(new String[]{"env"}).withHostConfig(HostConfig.newHostConfig().withLinks(new Link[]{new Link(containerName1, "container1Link")})).exec();
        LOG.info("Created container {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link(containerName1, "container1Link")}));
    }

    @Test
    public void createContainerWithMemorySwappiness() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(HostConfig.newHostConfig().withMemorySwappiness(Long.valueOf(42L))).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        LOG.info("Created container {}", (Object)container.toString());
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        LOG.info("Started container {}", (Object)container.toString());
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        Assert.assertSame((Object)42L, (Object)inspectContainerResponse.getHostConfig().getMemorySwappiness());
    }

    @Test
    public void createContainerWithLinkInCustomNetwork() throws DockerException {
        String containerName1 = "containerCustomlink_";
        String containerName2 = "containerCustom2link_";
        String networkName = "linkNetcustom";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withDriver("bridge").exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container1 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withNetworkMode(networkName)).withCmd(new String[]{"sleep", "9999"}).withName(containerName1).exec();
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerRule.getClient().inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        CreateContainerResponse container2 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withLinks(new Link[]{new Link(containerName1, containerName1 + "Link")}).withNetworkMode(networkName)).withName(containerName2).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container2.getId()).exec();
        ContainerNetwork linkNet = (ContainerNetwork)inspectContainerResponse2.getNetworkSettings().getNetworks().get(networkName);
        Assert.assertNotNull((Object)linkNet);
        MatcherAssert.assertThat((Object)linkNet.getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link(containerName1, containerName1 + "Link")}));
    }

    @Test
    public void createContainerWithCustomIp() throws DockerException {
        String containerName1 = "containerCustomIplink_";
        String networkName = "customIpNet";
        String subnetPrefix = "10.100.101";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withIpam(new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet(subnetPrefix + ".0/24")})).withDriver("bridge").withName(networkName).exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withNetworkMode(networkName)).withCmd(new String[]{"sleep", "9999"}).withName(containerName1).withIpv4Address(subnetPrefix + ".100").exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        ContainerNetwork customIpNet = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get(networkName);
        Assert.assertNotNull((Object)customIpNet);
        MatcherAssert.assertThat((Object)customIpNet.getGateway(), (Matcher)Matchers.is((Object)(subnetPrefix + ".1")));
        MatcherAssert.assertThat((Object)customIpNet.getIpAddress(), (Matcher)Matchers.is((Object)(subnetPrefix + ".100")));
    }

    @Test
    public void createContainerWithAlias() throws DockerException {
        String containerName1 = "containerAlias_";
        String networkName = "aliasNet";
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withDriver("bridge").exec();
        Assert.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withNetworkMode(networkName)).withCmd(new String[]{"sleep", "9999"}).withName(containerName1).withAliases(new String[]{"server"}).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        ContainerNetwork aliasNet = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get(networkName);
        MatcherAssert.assertThat((Object)aliasNet.getAliases(), (Matcher)Matchers.hasItem((Object)"server"));
    }

    @Test
    public void createContainerWithCapAddAndCapDrop() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withCapAdd(new Capability[]{Capability.NET_ADMIN}).withCapDrop(new Capability[]{Capability.MKNOD})).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapAdd()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.NET_ADMIN}));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapDrop()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.MKNOD}));
    }

    @Test
    public void createContainerWithDns() throws DockerException {
        String aDnsServer = "8.8.8.8";
        String anotherDnsServer = "8.8.4.4";
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"true"}).withHostConfig(HostConfig.newHostConfig().withDns(new String[]{aDnsServer, anotherDnsServer})).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDns()), (Matcher)Matchers.contains((Object[])new String[]{aDnsServer, anotherDnsServer}));
    }

    @Test
    public void createContainerWithEntrypoint() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName("containerEntrypoint").withEntrypoint(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEntrypoint()), (Matcher)Matchers.contains((Object[])new String[]{"sleep", "9999"}));
    }

    @Test
    public void createContainerWithExtraHosts() throws DockerException {
        String[] extraHosts = new String[]{"dockerhost:127.0.0.1", "otherhost:10.0.0.1"};
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName("containerextrahosts").withHostConfig(HostConfig.newHostConfig().withExtraHosts(extraHosts)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getExtraHosts()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dockerhost:127.0.0.1", "otherhost:10.0.0.1"}));
    }

    @Test
    public void createContainerWithDevices() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(HostConfig.newHostConfig().withDevices(new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")})).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDevices()), (Matcher)Matchers.contains((Object[])new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}));
    }

    @Test
    public void createContainerWithPortBindings() throws DockerException {
        int baseport = 10000;
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding.bindPort((int)(baseport + 22)));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)(baseport + 23)));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)(baseport + 24)));
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"true"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).withHostConfig(HostConfig.newHostConfig().withPortBindings(portBindings)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getExposedPorts()), (Matcher)Matchers.contains((Object[])new ExposedPort[]{tcp22, tcp23}));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp22))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)(baseport + 22)))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)(baseport + 23)))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)(baseport + 24)))));
    }

    @Test
    public void createContainerWithLinking() throws DockerException {
        String containerName1 = "containerWithlinking_";
        String containerName2 = "container2Withlinking_";
        CreateContainerResponse container1 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withName(containerName1).exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerRule.getClient().inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.startsWith((String)container1.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getName(), (Matcher)Matchers.equalTo((Object)("/" + containerName1)));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse1.getState().getRunning().booleanValue()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
        CreateContainerResponse container2 = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withName(containerName2).withHostConfig(HostConfig.newHostConfig().withLinks(new Link[]{new Link(containerName1, containerName1 + "Link")})).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse2 = this.dockerRule.getClient().inspectContainerCmd(container2.getId()).exec();
        LOG.info("Container2 Inspect: {}", (Object)inspectContainerResponse2.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link(containerName1, containerName1 + "Link")}));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.startsWith((String)container2.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getName(), (Matcher)Matchers.equalTo((Object)("/" + containerName2)));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
    }

    @Test
    public void createContainerWithRestartPolicy() throws DockerException {
        RestartPolicy restartPolicy = RestartPolicy.onFailureRestart((int)5);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(HostConfig.newHostConfig().withRestartPolicy(restartPolicy)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getRestartPolicy(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)restartPolicy)));
    }

    @Test
    public void createContainerWithPidMode() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"true"}).withHostConfig(HostConfig.newHostConfig().withPidMode("host")).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getPidMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void createContainerWithNetworkMode() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"true"}).withHostConfig(HostConfig.newHostConfig().withNetworkMode("host")).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNetworkMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void createContainerWithMacAddress() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withMacAddress("00:80:41:ae:fd:7e").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getMacAddress(), (Matcher)Matchers.is((Object)"00:80:41:ae:fd:7e"));
    }

    @Test
    public void createContainerWithULimits() throws DockerException {
        String containerName = "containerulimit";
        Ulimit[] ulimits = new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096)};
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName(containerName).withHostConfig(HostConfig.newHostConfig().withUlimits(ulimits)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getUlimits()), (Matcher)Matchers.containsInAnyOrder((Object[])new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096)}));
    }

    @Test
    public void createContainerWithIntegerBoundsExceedingULimit() throws DockerException {
        String containerName = "containercoreulimit";
        Ulimit[] ulimits = new Ulimit[]{new Ulimit("core", 99999999998L, 99999999999L)};
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withName(containerName).withHostConfig(HostConfig.newHostConfig().withUlimits(ulimits)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getUlimits()), (Matcher)Matchers.contains((Object[])new Ulimit[]{new Ulimit("core", 99999999998L, 99999999999L)}));
    }

    @Test
    public void createContainerWithLabels() throws DockerException {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("com.github.dockerjava.null", null);
        labels.put("com.github.dockerjava.Boolean", "true");
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withLabels(labels).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        labels.put("com.github.dockerjava.null", "");
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getLabels(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"com.github.dockerjava.null", (Object)""), (Matcher)Matchers.hasEntry((Object)"com.github.dockerjava.Boolean", (Object)"true")));
    }

    @Test
    public void createContainerWithLogConfig() throws DockerException {
        LogConfig logConfig = new LogConfig(LogConfig.LoggingType.NONE, null);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(HostConfig.newHostConfig().withLogConfig(logConfig)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getLogConfig().type, (Matcher)Matchers.is((Object)logConfig.type));
    }

    @Test
    public void testWithStopSignal() throws Exception {
        Integer signal = 10;
        CreateContainerResponse resp = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"/bin/sh", "-c", "trap 'echo \"exit trapped 10\"; exit 10' USR1; while true; do sleep 1; done"}).withAttachStdin(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).withStopSignal(signal.toString()).exec();
        String containerId = resp.getId();
        MatcherAssert.assertThat((Object)containerId, (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        this.dockerRule.getClient().startContainerCmd(containerId).exec();
        InspectContainerResponse inspect = this.dockerRule.getClient().inspectContainerCmd(containerId).exec();
        MatcherAssert.assertThat((Object)inspect.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        this.dockerRule.getClient().stopContainerCmd(containerId).exec();
        Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
        inspect = this.dockerRule.getClient().inspectContainerCmd(containerId).exec();
        MatcherAssert.assertThat((Object)inspect.getState().getRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)inspect.getState().getExitCode(), (Matcher)Matchers.is((Object)signal));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilderLogReader callback = new StringBuilderLogReader(stringBuilder);
        ((StringBuilderLogReader)this.dockerRule.getClient().logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)callback)).awaitCompletion();
        String log = callback.builder.toString();
        MatcherAssert.assertThat((Object)log.trim(), (Matcher)Matchers.is((Object)"exit trapped 10"));
    }

    @Test
    public void createContainerWithCgroupParent() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox").withHostConfig(HostConfig.newHostConfig().withCgroupParent("/parent")).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainer = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainer.getHostConfig().getCgroupParent(), (Matcher)Matchers.is((Object)"/parent"));
    }

    @Test
    public void createContainerWithShmSize() throws DockerException {
        HostConfig hostConfig = new HostConfig().withShmSize(Long.valueOf(0x6000000L));
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(hostConfig).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getShmSize(), (Matcher)Matchers.is((Object)hostConfig.getShmSize()));
    }

    @Test
    public void createContainerWithShmPidsLimit() throws DockerException {
        Assume.assumeThat((String)"API version should be >= 1.23", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_23));
        HostConfig hostConfig = new HostConfig().withPidsLimit(Long.valueOf(2L));
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withHostConfig(hostConfig).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getPidsLimit(), (Matcher)Matchers.is((Object)hostConfig.getPidsLimit()));
    }

    @Test
    public void createContainerWithNetworkID() {
        Assume.assumeThat((String)"API version should be >= 1.23", (Object)((Object)this.dockerRule), DockerMatchers.isGreaterOrEqual(RemoteApiVersion.VERSION_1_24));
        String networkName = "net-" + UUID.randomUUID().toString();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("com.example.label", "test");
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerRule.getClient().createNetworkCmd().withName(networkName).withLabels(labels).withAttachable(Boolean.valueOf(true)).exec();
        String networkId = createNetworkResponse.getId();
        CreateContainerResponse createContainerResponse = this.dockerRule.getClient().createContainerCmd("busybox:latest").withLabels(labels).withCmd(new String[]{"true"}).exec();
        String containerId = createContainerResponse.getId();
        this.dockerRule.getClient().connectToNetworkCmd().withContainerId(containerId).withNetworkId(networkId).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(containerId).exec();
        ContainerNetwork containerNetwork = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get(networkName);
        if (containerNetwork == null) {
            containerNetwork = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get(networkId);
        }
        MatcherAssert.assertThat((Object)containerNetwork, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void createContainerFromPrivateRegistryWithValidAuth() throws Exception {
        DockerAssume.assumeSwarm(this.dockerRule.getClient());
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        String imgName = REGISTRY.createPrivateImage("create-container-with-valid-auth");
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd(imgName).withAuthConfig(authConfig).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void createContainerFromPrivateRegistryWithNoAuth() throws Exception {
        AuthConfig authConfig = REGISTRY.getAuthConfig();
        String imgName = REGISTRY.createPrivateImage("create-container-with-no-auth");
        if (TestUtils.isSwarm(this.dockerRule.getClient())) {
            this.exception.expect(Matchers.instanceOf(InternalServerErrorException.class));
        } else {
            this.exception.expect(Matchers.instanceOf(NotFoundException.class));
        }
        this.dockerRule.getClient().createContainerCmd(imgName).exec();
    }

    @Test
    public void createContainerWithTmpFs() throws DockerException {
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(new HostConfig().withTmpFs(Collections.singletonMap("/tmp", "rw,noexec,nosuid,size=50m"))).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(inspectContainerResponse.getHostConfig().getTmpFs().get("/tmp"), (Matcher)Matchers.equalTo((Object)"rw,noexec,nosuid,size=50m"));
    }

    @Test
    public void createContainerWithNanoCPUs() throws DockerException {
        Long nanoCPUs = 1000000000L;
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(HostConfig.newHostConfig().withNanoCPUs(nanoCPUs)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.emptyString())));
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNanoCPUs(), (Matcher)Matchers.is((Object)nanoCPUs));
    }

    @Test
    public void overrideHostConfigWithRawValues() {
        HostConfig hostConfig = new HostConfig().withNanoCPUs(Long.valueOf(1000000000L));
        DockerObjectAccessor.overrideRawValue((DockerObject)hostConfig, (String)"NanoCPUs", (Object)500000000L);
        CreateContainerResponse container = this.dockerRule.getClient().createContainerCmd("busybox:latest").withCmd(new String[]{"sleep", "9999"}).withHostConfig(hostConfig).exec();
        LOG.info("Created container {}", (Object)container.toString());
        InspectContainerResponse inspectContainerResponse = this.dockerRule.getClient().inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNanoCPUs(), (Matcher)Matchers.is((Object)500000000L));
    }

    @Test
    public void shouldNotEncodeAuth() {
        CreateContainerCmd cmd = this.dockerRule.getClient().createContainerCmd("busybox:latest").withAuthConfig(new AuthConfig().withEmail("test@test.com")).withCmd(new String[]{"sleep", "9999"});
        ObjectMapper objectMapper = this.dockerRule.getConfig().getObjectMapper();
        ObjectNode jsonNode = (ObjectNode)objectMapper.valueToTree((Object)cmd);
        MatcherAssert.assertThat((Object)jsonNode.get("authConfig"), (Matcher)Matchers.nullValue());
    }

    private static class StringBuilderLogReader
    extends ResultCallback.Adapter<Frame> {
        public StringBuilder builder;

        public StringBuilderLogReader(StringBuilder builder) {
            this.builder = builder;
        }

        public void onNext(Frame item) {
            this.builder.append(new String(item.getPayload()));
            super.onNext((Object)item);
        }
    }
}

